package com.xunlei.emoticon.mall.repository;

import com.xunlei.emoticon.mall.domain.Emoticon;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.stream.Stream;

/**
 * @author Shunli
 */
public interface EmoticonRepository extends PagingAndSortingRepository<Emoticon, Long> {
    Stream<Emoticon> findTop6ByEmoticonPackIdAndEnabledTrue(Long emoticonPackId, Sort sort);

    @Query(value = "select * from emoticon where channel_id = ?1 and enabled = 1 order by rand() limit ?2", nativeQuery = true)
    Stream<Emoticon> findRandomByChannelIdAndEnabledTrue(Long channelId, int random);

    Page<Emoticon> findByChannelIdAndEmoticonPackIdAndEnabledTrue(Long channelId, Long emoticonPackId, Pageable pageable);

    Page<Emoticon> findByChannelIdAndEmoticonPackId(Long channelId, Long emoticonPackId, Pageable pageable);

    Stream<Emoticon> findByEmoticonPackId(Long emoticonPackId);

    @Query("select e from Emoticon e where e.channelId = ?1 and e.emoticonPackId is NULL " +
            " and (?2 is NULL or e.isGIF = ?2) and (?3 is NULL or e.enabled = ?3) ")
    Page<Emoticon> search(Long channelId, Boolean isGIF, Boolean enabled, Pageable pageable);
}
