package com.xunlei.emoticon.mall.repository;

import com.xunlei.emoticon.mall.domain.EmoticonPopularity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Shunli
 */
public interface EmoticonPopularityRepository extends PagingAndSortingRepository<EmoticonPopularity, Long> {
    Page<EmoticonPopularity> findByEmoticonChannelIdAndEmoticonEnabledTrue(Long channelId, Pageable pageable);

    @Modifying
    @Transactional
    @Query(value = "insert into emoticon_popularity(emoticon_id, popularity) values(?1, ?2) " +
            " on duplicate key update popularity = popularity + ?2 ", nativeQuery = true)
    void updatePopularity(Long emoticonId, int score);
}
