package com.xunlei.emoticon.mall.repository;

import com.xunlei.emoticon.mall.domain.EmoticonPack;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.stream.Stream;

/**
 * @author Shunli
 */
public interface EmoticonPackRepository extends PagingAndSortingRepository<EmoticonPack, Long> {
    Stream<EmoticonPack> findByChannelIdAndRecommendedTrueAndEnabledTrue(Long channelId, Sort sort);

    Page<EmoticonPack> findByChannelIdAndRecommendedFalseAndEnabledTrue(Long channelId, Pageable pageable);

    Page<EmoticonPack> findByChannelId(Long channelId, Pageable pageable);
}
