package com.xunlei.emoticon.mall.domain;

import com.xunlei.emoticon.mall.constant.Action;
import com.xunlei.emoticon.mall.constant.Type;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

/**
 * 操作记录
 *
 * @author Shunli
 */
@Entity
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Recorder extends AbstractEntity {
    private static final long serialVersionUID = -891236320219275978L;

    @Enumerated(EnumType.STRING)
    private Action action;
    @Enumerated(EnumType.STRING)
    private Type type;
    private Long sourceId;
    private String deviceId;
}
