package com.xunlei.emoticon.mall.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xunlei.emoticon.mall.constant.DeviceSize;
import com.xunlei.emoticon.mall.constant.DeviceType;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;

/**
 * 广告图片
 *
 * @author Shunli
 */
@Entity
@NoArgsConstructor
@AllArgsConstructor
public class AdImage extends AbstractEntity {
    private static final long serialVersionUID = -7744413247517879657L;

    @ManyToOne
    private Ad ad;

    private String url;
    @Enumerated(EnumType.STRING)
    private DeviceType deviceType;
    @Enumerated(EnumType.STRING)
    private DeviceSize deviceSize;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public DeviceSize getDeviceSize() {
        return deviceSize;
    }

    public void setDeviceSize(DeviceSize deviceSize) {
        this.deviceSize = deviceSize;
    }

    @JsonIgnore
    public Ad getAd() {
        return ad;
    }

    public void setAd(Ad ad) {
        this.ad = ad;
    }
}
