package com.xunlei.emoticon.mall.config;

import org.apache.commons.fileupload.FileItemFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

/**
 * @author Shunli
 */
@Configuration
@ConditionalOnClass({CommonsMultipartResolver.class, FileItemFactory.class})
@ConditionalOnProperty(prefix = "spring.http.multipart", name = "enabled", matchIfMissing = true)
public class MultipartConfig {

    @Bean
    @ConfigurationProperties(prefix = "spring.http.multipart")
    public MultipartResolver multipartResolver() {
        return new CommonsMultipartResolver();
    }
}
