package com.xunlei.emoticon.mall.config;

import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ExportMetricWriter;
import org.springframework.boot.actuate.metrics.opentsdb.DefaultOpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbGaugeWriter;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.writer.GaugeWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

/**
 * @author Shunli
 */
@Configuration
@ConditionalOnProperty(prefix = "spring.metrics.export", name = "url")
public class MetricConfig {
    @Value("${spring.application.name:application}")
    private String application;

    @Bean
    @ConfigurationProperties("spring.metrics.export")
    @ExportMetricWriter
    public GaugeWriter openTsdbMetricWriter() {
        OpenTsdbGaugeWriter writer = new OpenTsdbGaugeWriter();
        writer.setNamingStrategy(namingStrategy());
        return writer;
    }

    @Bean
    public OpenTsdbNamingStrategy namingStrategy() {
        Map<String, String> tags = Maps.newHashMap();
        tags.put(DefaultOpenTsdbNamingStrategy.DOMAIN_KEY, application);
        tags.put(DefaultOpenTsdbNamingStrategy.PROCESS_KEY, getHostName());

        DefaultOpenTsdbNamingStrategy namingStrategy = new DefaultOpenTsdbNamingStrategy();
        namingStrategy.setTags(tags);
        return namingStrategy;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException uhe) {
            return "server";
        }
    }
}
