package com.xunlei.monitor.uniononlinepay.handler;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.xunlei.channel.xlpayproxyutil.common.util.PriceUtil;
import com.xunlei.channel.xlwechatpay.bean.WeChatWebPayReq;
import com.xunlei.channel.xlwechatpay.bean.WeChatWebPayRes;
import com.xunlei.channel.xlwechatpay.client.WeChatWebPayClient;
import com.xunlei.channel.xlwechatpay.constant.WeChatPayResCode;
import com.xunlei.channel.xlwechatpay.constant.WeChatStatus;
import com.xunlei.channel.xlwechatpay.constant.WeChatWebPayConfig;
import com.xunlei.channel.xlwechatpay.exception.WeChatPayException;
import com.xunlei.monitor.uniononlinepay.constant.MonitorBean;

/**
 * 微信支付(Web扫码)后督程序
 * 
 * @author huangchunhui 2014年1月26日 上午10:39:01
 */
public class MonitorWeChatWebPayHandler {

    private static final Logger LOG = LoggerFactory.getLogger(MonitorWeChatWebPayHandler.class);

    /**
     * 交易查询
     * 
     * @param orderId
     * @param orderStatus
     * @return
     */
    public HashMap<String, String> weChatWebPayQuery(String orderId, String orderStatus) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            checkParam(new String[] { orderId, orderStatus });// 校验
            MonitorBean bean = queryWechatConsume(orderId, orderStatus);// 交易状态
            resultMap = analysisRes(bean);// 获取返回
        } catch (WeChatPayException e) {
            LOG.info(e.toString());// 自定义异常只做info级别输出
            resultMap = getExcepionResult();
        }
        LOG.info("===orderId:{},MonitorUnionOnlinePayHandler weChatWebPayQuery end, response{}===", new Object[] { orderId, resultMap });
        return resultMap;
    }

    /**
     * 参数检查
     * 
     * @param orderid
     * @param inputtime
     * @throws WeChatPayException
     */
    private void checkParam(String params[]) throws WeChatPayException {
        // 非空检查
        for (int i = 0; i < params.length; i++) {
            String param = params[i];
            if (null == param || "".equals(param)) {
                throw new WeChatPayException(WeChatPayResCode.RTN1001);
            }
        }
    }

    /**
     * 查询交易状态
     * 
     * @param orderId
     * @param orderStatus
     * @return
     * @throws WeChatPayException
     */
    private MonitorBean queryWechatConsume(String orderId, String orderStatus) throws WeChatPayException {

        MonitorBean bean = new MonitorBean();
        // 组请求报文
        WeChatWebPayReq weChatWebPayReq = new WeChatWebPayReq();
        weChatWebPayReq.setPartner(WeChatWebPayConfig.PARTNER);// 商户号
        weChatWebPayReq.setOut_trade_no(orderId);// 商户订单号
        weChatWebPayReq.setFaceFileName(WeChatWebPayConfig.WECHATWEBPAY_ORDERQUERY);
        WeChatWebPayRes weChatWebPayRes = WeChatWebPayClient.executeOrderQuery(weChatWebPayReq);

        if (null == weChatWebPayRes) {
            throw new WeChatPayException(WeChatPayResCode.RTN1007);// 查询接口返回为空
        }

        String retcode = weChatWebPayRes.getRetcode();
        String trade_state = weChatWebPayRes.getTrade_state();
        String retmsg = weChatWebPayRes.getRetmsg();
        String total_fee = weChatWebPayRes.getTotal_fee();

        Object payRes[] = new Object[] { orderId, retcode, trade_state, retmsg, total_fee };
        LOG.info("orderId:{},executeOrderQuery reponse[retcode:{},trade_state:{},retmsg:{},total_fee:{}]", payRes);

        if (null == retcode || "".equals(retcode)) {
            throw new WeChatPayException(WeChatPayResCode.RTN1007);// 查询返回码为空
        }

        if (retcode.equals(WeChatStatus.SUCCESS)) {
            // 返回状态码成功
            if (null == trade_state || "".equals(trade_state)) {
                throw new WeChatPayException(WeChatPayResCode.RTN1007);// 订单状态返回为空
            }

            if (trade_state.equals(WeChatStatus.SUCCESS)) {
                String orderAmt = PriceUtil.Fen2Yuan(total_fee);
                LOG.info("orderId:{},total_fee:{},after parse orderAmt:{}", new Object[] { orderId, total_fee, orderAmt });
                // 支付成功
                bean.setTimeOut("N");
                bean.setCheckSuccess("Y");
                bean.setAmount(orderAmt);
                bean.setMsg("订单支付成功!");
            } else {
                // 支付失败
                bean.setTimeOut("N");
                bean.setCheckSuccess("N");
                bean.setAmount("-3");// 支付失败就不用校验金额了吧
                bean.setMsg("订单支付失败!");
            }
        } else {
            // 返回状态码失败(可能是订单不存在),也视作支付失败
            bean.setTimeOut("N");
            bean.setCheckSuccess("N");
            bean.setAmount("-3");
            bean.setMsg("订单支付失败!");
        }

        LOG.info("===orderId:{},queryWechatConsume result:{}=======", new Object[] { orderId, bean });
        return bean;
    }

    /**
     * 生成后督返回
     * 
     * @param result
     * @return
     * @throws Exception
     */
    private HashMap<String, String> analysisRes(MonitorBean bean) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timeOut", bean.getTimeOut());
        map.put("checkSuccess", bean.getCheckSuccess());
        map.put("amount", bean.getAmount());
        map.put("msg", bean.getMsg());
        return map;
    }

    /**
     * 生成后督异常返回,对于这种结果会重查
     * 
     * @param result
     * @return
     */
    private HashMap<String, String> getExcepionResult() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timeOut", "Y");
        map.put("checkSuccess", "N");
        map.put("amount", "-3");
        map.put("msg", "订单查询异常");
        return map;
    }
}
