/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.xlpayproxyutil.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final String SP1 = "yyyy-MM-dd HH:mm:ss";
    public static final String SP2 = "yyyyMMddHHmmss";
    public static final String SP3 = "yyyy-MM-dd";
    public static final String SP4 = "yyyyMMdd";

    public static String parseTime(String time, String formatStrBefore, String formatStrAfter) throws ParseException {
        SimpleDateFormat bfSp = new SimpleDateFormat(formatStrBefore);
        SimpleDateFormat afSp = new SimpleDateFormat(formatStrAfter);
        return afSp.format(bfSp.parse(time));
    }

    public static int compareTime(String time1, String time2, String formatStr) throws ParseException {
        Date date2;
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Date date1 = sp.parse(time1);
        if (date1.before(date2 = sp.parse(time2))) {
            return 1;
        }
        if (date1.after(date2)) {
            return -1;
        }
        return 0;
    }

    public static String getCurrentTime(String formatStr) {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        return sp.format(new Date());
    }

    public static String getTimeAfter(int field, int amount, String formatStr) {
        Calendar cal = Calendar.getInstance();
        cal.add(field, amount);
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        return sp.format(cal.getTime());
    }

    public static String getFirstDayOfMonth(String formatStr) {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Calendar date = Calendar.getInstance();
        date.set(5, 1);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        return sp.format(date.getTime());
    }

    public static String calculateTime(String time, String addpart, int num) throws ParseException {
        SimpleDateFormat yyyyMMddHHmmssDateFormat = new SimpleDateFormat(SP1);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(yyyyMMddHHmmssDateFormat.parse(time));
        if (addpart.equalsIgnoreCase("Y")) {
            cal.add(1, num);
        } else if (addpart.equalsIgnoreCase("M")) {
            cal.add(2, num);
        } else if (addpart.equalsIgnoreCase("D")) {
            cal.add(5, num);
        } else if (addpart.equalsIgnoreCase("H")) {
            cal.add(10, num);
        } else if (addpart.equalsIgnoreCase("F")) {
            cal.add(12, num);
        } else if (addpart.equalsIgnoreCase("S")) {
            cal.add(13, num);
        }
        return yyyyMMddHHmmssDateFormat.format(cal.getTime());
    }

    public static long dateDiffer(String time1, String time2, String formatStr) throws ParseException {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Date date1 = sp.parse(time1);
        Date date2 = sp.parse(time2);
        long differ = Math.abs(date1.getTime() - date2.getTime());
        return differ;
    }

    public static String getTimeAfter(int amount, String str) {
        Calendar cal = Calendar.getInstance();
        cal.add(11, amount);
        SimpleDateFormat sp = new SimpleDateFormat(str);
        return sp.format(cal.getTime());
    }
}

