/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.xlpayproxyutil.common.encrypt;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA_SHA1Encrypt {
    private static final Logger LOG = LoggerFactory.getLogger(RSA_SHA1Encrypt.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    public static final String ENCODING = "utf-8";
    public static final String X509 = "X.509";

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = UrlBase64.decode((byte[])key.getBytes(ENCODING));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = UrlBase64.decode((byte[])key.getBytes(ENCODING));
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        ByteArrayInputStream in = new ByteArrayInputStream(keyBytes);
        Certificate certificate = certificateFactory.generateCertificate(in);
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    public static String signByPrivateKey(String content, String privateKey) {
        try {
            PrivateKey priKey = RSA_SHA1Encrypt.getPrivateKey(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(priKey);
            signature.update(content.getBytes(ENCODING));
            byte[] signed = signature.sign();
            return new String(UrlBase64.encode((byte[])signed), ENCODING);
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, priKey: {}", new Object[]{content, privateKey});
            LOG.error("sign error", (Throwable)e);
            return null;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = UrlBase64.decode((byte[])publicKey.getBytes(ENCODING));
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(ENCODING));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey, String ENCODING) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = UrlBase64.decode((byte[])publicKey.getBytes(ENCODING));
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(ENCODING));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSourceKey(String path) {
        BufferedReader reader = null;
        StringBuffer sourceKey = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(path));
            String part = reader.readLine();
            part = reader.readLine();
            while (part.charAt(0) != '-') {
                sourceKey.append(part + "\r");
                part = reader.readLine();
            }
        }
        catch (Exception e) {
            LOG.error("readSourceKey throws Exception:", (Throwable)e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return sourceKey.toString();
    }
}

