/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.xlicbcretrievepay.manager;

import com.xunlei.channel.xlicbcretrievepay.manager.RetrieveManager;
import com.xunlei.channel.xlicbcretrievepay.util.IcbcUtil;
import com.xunlei.channel.xlicbcretrievepay.vo.IcbcRetrieveVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class RetrieveManagerImpl
implements RetrieveManager {
    private static final Logger log = Logger.getLogger(RetrieveManagerImpl.class);
    @Autowired
    VelocityEngine velocityEngine;
    private static final String templatename = "IcbcRetrieve.html";

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public Map retrieveIcbcDudect(IcbcRetrieveVo retrieveVo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("transCode", retrieveVo.getTransCode());
        map.put("CIS", retrieveVo.getCIS());
        map.put("bankCode", retrieveVo.getBankCode());
        map.put("ID", retrieveVo.getID());
        map.put("tranDate", retrieveVo.getTranDate());
        map.put("tranTime", retrieveVo.getTranTime());
        map.put("fSeqno", retrieveVo.getfSeqno());
        map.put("qryfSeqno", retrieveVo.getQryfSeqno());
        map.put("QrySerialNo", retrieveVo.getQrySerialNo());
        map.put("reqReserved1", retrieveVo.getReqReserved1());
        map.put("reqReserved2", retrieveVo.getReqReserved2());
        map.put("iSeqno", retrieveVo.getiSeqno());
        map.put("qryiSeqno", retrieveVo.getQryiSeqno());
        map.put("qryOrderNo", retrieveVo.getQryOrderNo());
        map.put("reqReserved3", retrieveVo.getReqReserved3());
        map.put("reqReserved4", retrieveVo.getReqReserved4());
        String XMLReqData = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)templatename, map);
        log.info((Object)("xml\u660e\u6587" + XMLReqData));
        String resultXML = "";
        Map<Object, Object> resultMap = new HashMap<String, String>();
        try {
            HttpResponse response = this.sendData(IcbcUtil.safeServerIp, retrieveVo, XMLReqData);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"GB2312");
            if (!result.startsWith("reqData")) {
                resultMap.put("status", "14");
            }
            resultXML = result.substring(result.indexOf("reqData=") + 8);
            resultXML = IcbcUtil.decstrFromBase64(resultXML);
            log.info((Object)("INFO:" + resultXML));
        }
        catch (Exception e) {
            log.error((Object)("\u53d1\u9001\u6216\u8fd4\u56de\u5f02\u5e38:" + e.getMessage()));
            resultMap.put("status", "12");
            return resultMap;
        }
        if (resultXML.startsWith("<?xml")) {
            resultMap = this.getIcbcResult(resultXML);
        } else {
            resultMap = new HashMap();
            log.error((Object)("\u5de5\u884c\u8fd4\u56de\u6709\u8bef" + resultXML));
            resultMap.put("status", "13");
        }
        return resultMap;
    }

    private String getSignData(String XMLReqData) {
        int end;
        DefaultHttpClient client = new DefaultHttpClient();
        StringEntity entity = null;
        HttpEntity httpEntity = null;
        HttpPost post = null;
        String certdata = "";
        int len1 = XMLReqData.getBytes().length;
        try {
            entity = new StringEntity(XMLReqData);
            post = new HttpPost(IcbcUtil.signServerIp);
            post.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            post.setHeader("Content-Type", "INFOSEC_SIGN/1.0");
            post.setEntity((HttpEntity)entity);
            HttpResponse res = client.execute((HttpUriRequest)post);
            httpEntity = res.getEntity();
            if (httpEntity != null) {
                certdata = EntityUtils.toString((HttpEntity)httpEntity);
            }
            client.getConnectionManager().shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int start = certdata.indexOf("<sign>");
        if (start != -1) {
            certdata = certdata.substring(start + 6);
        }
        if ((end = certdata.indexOf("</sign>")) != -1) {
            certdata = certdata.substring(0, end);
        }
        return certdata;
    }

    public HttpResponse sendData(String path, IcbcRetrieveVo model, String certdata) throws Exception {
        log.info((Object)("path : " + path));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(path + "userID=" + model.getID() + "&PackageID=" + model.getfSeqno() + "&SendTime=" + IcbcUtil.yyyyMMddHHmmssFormat.format(new Date()));
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("Version", IcbcUtil.pikouversion));
        list.add(new BasicNameValuePair("TransCode", model.getTransCode()));
        list.add(new BasicNameValuePair("BankCode", model.getBankCode()));
        list.add(new BasicNameValuePair("GroupCIS", model.getCIS()));
        list.add(new BasicNameValuePair("ID", model.getID()));
        list.add(new BasicNameValuePair("PackageID", model.getfSeqno()));
        list.add(new BasicNameValuePair("Cert", ""));
        list.add(new BasicNameValuePair("reqData", certdata.trim()));
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setHeader("User-Agent", "directclient");
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "GB2312"));
            post.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            HttpResponse res = client.execute((HttpUriRequest)post);
            return res;
        }
        catch (Exception e) {
            log.info((Object)("\u8fde\u63a5\u8d85\u65f6" + e.getMessage()));
            throw e;
        }
    }

    public Map<String, String> getIcbcResult(String xmlPlain) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Document document = DocumentHelper.parseText((String)xmlPlain);
            Element e = (Element)document.selectSingleNode("//CMS/eb/out/rd/Result");
            log.info((Object)("result +=================" + e.getText()));
            Element retCode = (Element)document.selectSingleNode("//CMS/eb/pub/RetCode");
            Element retMsg = (Element)document.selectSingleNode("//CMS/eb/pub/RetMsg");
            Element iRetMsg = (Element)document.selectSingleNode("//CMS/eb/out/rd/iRetMsg");
            if (retCode != null && "0".equals(retCode.getText())) {
                if (e != null && "7".equals(e.getText())) {
                    map.put("status", "00");
                    Element amt = (Element)document.selectSingleNode("//CMS/eb/out/RetTotalAmt");
                    if (amt != null) {
                        map.put("amt", amt.getText());
                    } else {
                        map.put("status", "15");
                    }
                } else if (e != null) {
                    log.info((Object)("\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4f46\u672a\u5904\u7406" + e.getText()));
                    map.put("status", e.getText());
                }
            } else {
                log.info((Object)"\u6307\u4ee4\u63d0\u4ea4\u53ef\u80fd\u672a\u6210\u529f");
                map.put("status", "16");
            }
            return map;
        }
        catch (DocumentException e) {
            log.debug((Object)"==================>>>>\u8f7d\u5165xml\u51fa\u9519");
            return null;
        }
    }
}

