package com.xunlei.channel.xlcmbpay.check;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import cmb.netpayment.Settle;

/**
 * @author hexin
 */
public class CmbCheck {

    private Settle settle;
    private String password;
    private String strBranchID;
    private String strCono;
    private ResourceBundle resource;
    private boolean isLogin = false;

    public ResourceBundle getResource() {
        return resource;
    }

    protected Logger log = Logger.getLogger(CmbCheck.class);

    private CmbCheck() {
        init();
    }

    private static class CmbCheckHolder {

        static CmbCheck instance = new CmbCheck();
    }

    public static CmbCheck getInstance() {
        return CmbCheckHolder.instance;
    }

    private void init() {
        resource = ResourceBundle.getBundle("cmbpaycheck");
        strCono = resource.getString("strCono");
        password = resource.getString("password");
        strBranchID = resource.getString("strBranchID");
        settle = new Settle();
        int result = settle.SetOptions("payment.ebank.cmbchina.com");
        if (result == 0) {
            log.info("setoptions ok");
        } else {
            log.info("error: " + settle.GetLastErr(result));
        }
    }

    public boolean login(String strBranchID, String companyNo, String password) {
        if (!this.isLogin) {
            int result = settle.LoginC(strBranchID, companyNo, password);
            if (result == 0) {
                log.info("cmb login success!!");
                isLogin = true;
            } else {
                isLogin = false;
                log.info("error :" + settle.GetLastErr(result) + ",result:" + result);
                if (result == 2) {
                    isLogin = true;
                }
            }
        }
        return isLogin;
    }

    public void logout() {
        isLogin = false;
        settle.Logout();
    }

    /**
     * 强烈不建议用在循环查询中
     * 
     * @param date
     * @param billNo
     * @param orderAmt
     * @return
     */
    public synchronized CmbCheckRet querySingleOrder(String date, String billNo, double orderAmt) {
        //定义结果保存buffer
        StringBuffer buffer = new StringBuffer();
        //将页面重置
        //      settle.PageReset();
        CmbCheckRet retData = new CmbCheckRet();
        if (this.login(this.strBranchID, this.strCono, this.password)) {
            //查询
            int result = settle.QuerySingleOrder(date, billNo, buffer);

            if (result == 0) {
                String[] strArr = buffer.toString().split("\n");
                retData.setPayTime(strArr[0]);
                retData.setDealTime(strArr[1]);
                retData.setOrderStatus(strArr[2]);
                retData.setAmount(strArr[3]);
                if (retData.getOrderStatus().equals("0")) {
                    if (Double.valueOf(retData.getAmount()).doubleValue() == orderAmt) {
                        retData.setCheckStatus(0);
                    } else {
                        retData.setCheckStatus(3);
                    }
                } else {
                    retData.setCheckStatus(4);
                }
                log.info("cmb query success!");
            } else {
                log.info("error : " + settle.GetLastErr(result));
                retData.setCheckStatus(1);
            }
            logout();
        } else {
            retData.setCheckStatus(2);
        }
        return retData;
    }

    /**
     * 批量查询,参数set:{orderId, orderDate, orderAmt}返回map:[orderId,CmbCheckRet]
     * 
     * @param cmbOrderSet
     * @return
     */
    public Map<String, CmbCheckRet> queryOrderSet(Set<CmbOrder> cmbOrderSet) {
        Map<String, CmbCheckRet> retMap = new HashMap<String, CmbCheckRet>();
        Iterator<CmbOrder> item = cmbOrderSet.iterator();
        while (item.hasNext()) {
            CmbOrder order = item.next();
            CmbCheckRet retData = new CmbCheckRet();
            if (this.login(this.strBranchID, this.strCono, this.password)) {
                //定义结果保存buffer
                StringBuffer buffer = new StringBuffer();
                //查询
                int result = settle.QuerySingleOrder(order.getOrderDate(), order.getOrderId(), buffer);

                if (result == 0) {
                    String[] strArr = buffer.toString().split("\n");
                    retData.setPayTime(strArr[0]);
                    retData.setDealTime(strArr[1]);
                    retData.setOrderStatus(strArr[2]);
                    retData.setAmount(strArr[3]);
                    if (retData.getOrderStatus().equals("0")) {
                        if (Double.valueOf(retData.getAmount()).doubleValue() == order.getOrderAmt()) {
                            retData.setCheckStatus(0);
                        } else {
                            retData.setCheckStatus(3);
                        }
                    } else {
                        retData.setCheckStatus(4);
                    }
                    log.info("cmb query success!");
                } else {
                    log.info("error : " + settle.GetLastErr(result));
                    retData.setCheckStatus(1);
                }
            } else {
                retData.setCheckStatus(2);
            }
            retMap.put(order.getOrderId(), retData);
        }
        logout();
        return retMap;
    }

    public class CmbCheckRet {

        private int checkStatus = 0;
        private String payTime = "";
        private String dealTime = "";
        private String orderStatus = "0";
        private String amount = "0.00";

        /**
         * @return 查询状态：0-订单正常结账,1-订单未找到,2-网络通讯失败,3-结账金额不符,4-订单非正常结账
         */
        public int getCheckStatus() {
            return checkStatus;
        }

        public void setCheckStatus(int checkStatus) {
            this.checkStatus = checkStatus;
        }

        public String getPayTime() {
            return payTime;
        }

        public void setPayTime(String payTime) {
            this.payTime = payTime;
        }

        public String getDealTime() {
            return dealTime;
        }

        public void setDealTime(String dealTime) {
            this.dealTime = dealTime;
        }

        /**
         * @return 定单状态：0-已结帐,1-已撤销,2-部分结帐,3-退款,4-未结帐,5-无效状态,6-未知状态
         */
        public String getOrderStatus() {
            return orderStatus;
        }

        public void setOrderStatus(String orderStatus) {
            this.orderStatus = orderStatus;
        }

        public String getAmount() {
            return amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }

        @Override
        public String toString() {
            return "checkStatus:" + checkStatus + ",payTime:" + payTime + ",dealTime:" + dealTime + ",orderStatus:" + orderStatus + ",amount:" + amount;
        }
    }

    public class CmbOrder {

        private String orderId;
        private String orderDate;
        private double orderAmt;

        public String getOrderId() {
            return orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getOrderDate() {
            return orderDate;
        }

        public void setOrderDate(String orderDate) {
            this.orderDate = orderDate;
        }

        public double getOrderAmt() {
            return orderAmt;
        }

        public void setOrderAmt(double orderAmt) {
            this.orderAmt = orderAmt;
        }
    }

    public static void main(String[] a) {
        //      CmbCheck.getInstance().login("0755", "100186", "179510");
        //      CmbCheck.getInstance().login("0755", "100186", "179510");
        Set<CmbOrder> cmbOrderSet = new HashSet<CmbOrder>();
        CmbOrder c1 = CmbCheck.getInstance().new CmbOrder();
        c1.setOrderId("1060712716");
        c1.setOrderDate("20110607");
        c1.setOrderAmt(0.01);
        cmbOrderSet.add(c1);
        CmbOrder c2 = CmbCheck.getInstance().new CmbOrder();
        c2.setOrderId("1053049510");
        c2.setOrderDate("20110530");
        c2.setOrderAmt(10);
        cmbOrderSet.add(c2);
        System.out.println(CmbCheck.getInstance().queryOrderSet(cmbOrderSet));
        System.out.println(CmbCheck.getInstance().querySingleOrder("20121013", "1438508181", 10));
    }

}
