/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cmd;

import com.xunlei.channel.channelreport.statistics.bo.LeiMonthReportBo;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthReportStatisticsCmd
extends DefaultCmd {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    LeiMonthReportBo leiMonthReportBo;

    @CmdMapper(value={"/month_lei_statistics_all"})
    public Object allStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceMonth = request.getParameterCompelled("balancemonth");
        this.logger.info("month_lei_statistics_all...balancemonth:{}", (Object)balanceMonth);
        if (balanceMonth.length() != 7) {
            throw new IllegalParameterError("balancemonth", request, "String");
        }
        this.leiMonthReportBo.allStatistics(balanceMonth);
        return "ok";
    }

    @CmdMapper(value={"/month_lei_statistics_single"})
    public Object singleStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceMonth = request.getParameterCompelled("balancemonth");
        String paytype = request.getParameter("paytype");
        this.logger.info("month_lei_statistics_single...balancemonth:{},paytype:{}", (Object)balanceMonth, (Object)paytype);
        if (balanceMonth.length() != 7) {
            throw new IllegalParameterError("balancemonth", request, "String");
        }
        if (!StringTools.isNotEmpty((CharSequence)paytype)) {
            throw new IllegalParameterError("paytype", request, "String");
        }
        this.leiMonthReportBo.singleStatisticsByPaytype(balanceMonth, paytype);
        return "ok";
    }
}

