/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cmd;

import com.xunlei.channel.channelreport.statistics.bo.LeiDayReportBo;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiDayReportStatisticsCmd
extends DefaultCmd {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    LeiDayReportBo leiDayReportBo;

    @CmdMapper(value={"/day_lei_statistics_all"})
    public Object allStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceDate = request.getParameterCompelled("balancedate");
        this.logger.info("day_lei_statistics_all...balancedate:{}", (Object)balanceDate);
        if (balanceDate.length() != 10) {
            throw new IllegalParameterError("balancedate", request, "String");
        }
        this.leiDayReportBo.allStatistics(balanceDate);
        return "success";
    }

    @CmdMapper(value={"/day_lei_statistics_single"})
    public Object singleStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceDate = request.getParameterCompelled("balancedate");
        String paytype = request.getParameter("paytype");
        this.logger.info("day_lei_statistics_single...balancedate:{},paytype:{}", (Object)balanceDate, (Object)paytype);
        if (balanceDate.length() != 10) {
            throw new IllegalParameterError("balancedate", request, "String");
        }
        String result = "success";
        if (!StringTools.isNotEmpty((CharSequence)paytype)) {
            throw new IllegalParameterError("paytype", request, "String");
        }
        result = this.leiDayReportBo.singleStatisticsByPaytype(balanceDate, paytype);
        return result;
    }
}

