/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cmd;

import com.xunlei.channel.channelreport.statistics.bo.IncomeMonthReportBo;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthReportStatisticsCmd
extends DefaultCmd {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    IncomeMonthReportBo incomeMonthReportBo;

    @CmdMapper(value={"/month_income_statistics_all"})
    public Object allStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceMonth = request.getParameterCompelled("balancemonth");
        this.logger.info("month_income_statistics_all...balancemonth:{}", (Object)balanceMonth);
        if (balanceMonth.length() != 7) {
            throw new IllegalParameterError("balancedate", request, "String");
        }
        this.incomeMonthReportBo.allStatistics(balanceMonth);
        return "ok";
    }

    @CmdMapper(value={"/month_income_statistics_single"})
    public Object singleStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceMonth = request.getParameterCompelled("balancemonth");
        String paytype = request.getParameter("paytype");
        String bizno = request.getParameter("bizno");
        this.logger.info("month_income_statistics_single...balanceMonth:{},paytype:{},bizno:{}", new Object[]{balanceMonth, paytype, bizno});
        if (balanceMonth.length() != 7) {
            throw new IllegalParameterError("balancemonth", request, "String");
        }
        if (StringTools.isNotEmpty((CharSequence)paytype) && StringTools.isNotEmpty((CharSequence)bizno)) {
            this.incomeMonthReportBo.singleStatisticsByBiznoAndPaytype(balanceMonth, bizno, paytype);
        } else if (StringTools.isNotEmpty((CharSequence)paytype)) {
            this.incomeMonthReportBo.singleStatisticsByPaytype(balanceMonth, paytype);
        } else if (StringTools.isNotEmpty((CharSequence)bizno)) {
            this.incomeMonthReportBo.singleStatisticsByBizno(balanceMonth, bizno);
        } else {
            throw new IllegalParameterError("paytype or bizno", request, "String");
        }
        return "ok";
    }
}

