/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cmd;

import com.xunlei.channel.channelreport.statistics.bo.IncomeDayReportBo;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayReportStatisticsCmd
extends DefaultCmd {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    IncomeDayReportBo incomeDayReportBo;

    @CmdMapper(value={"/day_income_statistics_all"})
    public Object allStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceDate = request.getParameterCompelled("balancedate");
        this.logger.info("day_income_statistics_all...balancedate:{}", (Object)balanceDate);
        if (balanceDate.length() != 10) {
            throw new IllegalParameterError("balancedate", request, "String");
        }
        this.incomeDayReportBo.allStatistics2(balanceDate);
        return "success";
    }

    @CmdMapper(value={"/day_income_statistics_single"})
    public Object singleStatistics(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String balanceDate = request.getParameterCompelled("balancedate");
        String paytype = request.getParameter("paytype");
        String bizno = request.getParameter("bizno");
        this.logger.info("day_income_statistics_single...balancedate:{},paytype:{},bizno:{}", new Object[]{balanceDate, paytype, bizno});
        if (balanceDate.length() != 10) {
            throw new IllegalParameterError("balancedate", request, "String");
        }
        if (StringTools.isNotEmpty((CharSequence)paytype)) {
            this.incomeDayReportBo.singleStatisticsByPaytype(balanceDate, paytype);
        } else if (StringTools.isNotEmpty((CharSequence)bizno)) {
            this.incomeDayReportBo.singleStatisticsByBizno(balanceDate, bizno);
        } else {
            throw new IllegalParameterError("paytype or bizno", request, "String");
        }
        return "success";
    }
}

