/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cache;

import com.xunlei.channel.channelreport.statistics.cache.IncomeBizinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomeMansqlCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeReportsqlCache {
    private static final Logger log = LoggerFactory.getLogger(IncomeReportsqlCache.class);
    @Autowired
    IncomeBizinfoCache incomeBizinfoCache;
    @Autowired
    IncomePaytypeinfoCache incomePaytypeinfoCache;
    @Autowired
    IncomeMansqlCache incomeMansqlCache;
    private Map<String, String> INSTANCE = new HashMap<String, String>();
    private Map<String, String> MAN_SQL_MAP = new HashMap<String, String>();

    public void reload() {
        HashMap<String, String> INSTANCETmp = new HashMap<String, String>();
        Set<String> biznoSet = this.incomeBizinfoCache.getBiznoSet();
        Set<String> paytypeAndTypeSet = this.incomePaytypeinfoCache.getPaytypeAndTypeSet();
        Set<String> manSqlPaytypeAndTypeSet = this.incomePaytypeinfoCache.getMansqlPaytypeAndType();
        for (String paytypeAndType : paytypeAndTypeSet) {
            if (manSqlPaytypeAndTypeSet.contains(paytypeAndType)) {
                for (String bizno : biznoSet) {
                    String sql = this.incomeMansqlCache.getManSql(bizno, paytypeAndType);
                    if (sql == null) continue;
                    INSTANCETmp.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytypeAndType), sql);
                    this.MAN_SQL_MAP.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytypeAndType), sql);
                }
                continue;
            }
            for (String bizno : biznoSet) {
                String[] paytypeAndtypeArr = IncomeReportStatisticsUtil.splitPaytypeAndType(paytypeAndType);
                String sql = String.format("select sum(orderamt) from xlpayproxy.bizorderok where bizno='%s' and paytype='%s' and type='%s' and balancedate=?", bizno, paytypeAndtypeArr[0], paytypeAndtypeArr[1]);
                INSTANCETmp.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytypeAndType), sql);
            }
        }
        this.INSTANCE = INSTANCETmp;
        log.info("ReportsqlCache reload success...size:{}", (Object)this.INSTANCE.size());
    }

    public Map<String, String> getInstance() {
        return this.INSTANCE;
    }

    public Map<String, String> getManSqlMap() {
        return this.MAN_SQL_MAP;
    }
}

