/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cache;

import com.xunlei.channel.channelreport.dao.IncomePaytypeinfoDao;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomePaytypeinfoCache {
    private static final Logger log = LoggerFactory.getLogger(IncomePaytypeinfoCache.class);
    @Autowired
    IncomePaytypeinfoDao incomePaytypeinfoDao;
    private Map<String, Map<String, Object>> INSTANCE = new HashMap<String, Map<String, Object>>();
    private Set<String> mansqlPaytypeAndType = new HashSet<String>();

    public void reload() {
        HashMap INSTANCETmp = new HashMap();
        HashSet<String> mansqlPaytypeTmp = new HashSet<String>();
        List<HashMap<String, Object>> paytypeinfoMapList = this.incomePaytypeinfoDao.getPaytypeinfoMapList();
        for (Map map : paytypeinfoMapList) {
            String paytype = map.get("paytype").toString();
            String type = map.get("type").toString();
            INSTANCETmp.put(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type), Collections.unmodifiableMap(map));
            String sqlConfigFrom = map.get("sqlconfigfrom").toString();
            if (!"M".equals(sqlConfigFrom)) continue;
            mansqlPaytypeTmp.add(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type));
        }
        this.INSTANCE = Collections.unmodifiableMap(INSTANCETmp);
        this.mansqlPaytypeAndType = Collections.unmodifiableSet(mansqlPaytypeTmp);
        log.info("paytypeinfoCache reload success!");
    }

    public Set<String> getPaytypeAndTypeSet() {
        return this.INSTANCE.keySet();
    }

    public Set<String> getMansqlPaytypeAndType() {
        return this.mansqlPaytypeAndType;
    }

    public Map<String, Object> getPaytypeinfo(String paytypeAndType) {
        return this.INSTANCE.get(paytypeAndType);
    }
}

