/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.cache;

import com.xunlei.channel.channelreport.dao.IncomeMansqlDao;
import com.xunlei.channel.channelreport.statistics.cache.IncomeBizinfoCache;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMansqlCache {
    private static final Logger log = LoggerFactory.getLogger(IncomeMansqlCache.class);
    private Map<String, Map<String, Object>> INSTANCE = new HashMap<String, Map<String, Object>>();
    @Autowired
    IncomeMansqlDao incomeMansqlDao;
    @Autowired
    IncomeBizinfoCache incomeBizinfoCache;

    public void reload() {
        HashMap<String, Map<String, Object>> INSTANCETmp = new HashMap<String, Map<String, Object>>();
        List<Object> list = new ArrayList();
        list = this.incomeMansqlDao.getMansqlMapList();
        Set<String> biznoSet = this.incomeBizinfoCache.getBiznoSet();
        for (HashMap hashMap : list) {
            String bizno = hashMap.get("bizno").toString();
            String paytype = hashMap.get("paytype").toString();
            String type = hashMap.get("type").toString();
            if ("ALL".equals(bizno)) {
                for (String biznoReal : biznoSet) {
                    HashMap<String, String> mapReal = new HashMap<String, String>(hashMap);
                    String key = IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(biznoReal, paytype, type);
                    String reportsql = mapReal.get("reportsql").toString();
                    reportsql = reportsql.replace("bizno=?", "bizno='" + biznoReal + "'");
                    mapReal.put("reportsql", reportsql);
                    INSTANCETmp.put(key, mapReal);
                }
                continue;
            }
            String key = IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, type);
            INSTANCETmp.put(key, hashMap);
        }
        this.INSTANCE = INSTANCETmp;
        log.info("MansqlCache reload success");
    }

    public Set<String> getBiznoAndPaytype() {
        return this.INSTANCE.keySet();
    }

    public String getManSql(String bizno, String paytype) {
        Map<String, Object> map = this.INSTANCE.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype));
        if (map != null) {
            return map.get("reportsql").toString();
        }
        return null;
    }
}

