/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.bo;

import com.xunlei.channel.channelreport.dao.IncomePaytypeinfoDao;
import com.xunlei.channel.channelreport.dao.LeiMonthReportDao;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.LeiPaytypeinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.LeiReportsqlCache;
import com.xunlei.channel.channelreport.util.Arith;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthReportBo {
    private static final Logger log = LoggerFactory.getLogger(LeiMonthReportBo.class);
    @Autowired
    LeiReportsqlCache leiReportsqlCache;
    @Autowired
    LeiPaytypeinfoCache leiPaytypecCache;
    @Autowired
    LeiMonthReportDao leiMonthReportDao;
    @Autowired
    LeiPaytypeinfoCache leiPaytypeinfoCache;
    @Autowired
    IncomePaytypeinfoDao incomePaytypeinfoDao;
    @Autowired
    IncomePaytypeinfoCache incomePaytypeinfoCache;

    public void allStatistics(String balanceMonth) {
        this.leiMonthReportDao.deleteByBalanceMonth(balanceMonth);
        List<HashMap<String, Object>> biznoAndPaytypeAndRealPaytypeList = this.leiMonthReportDao.getDistinctPaytypeAndRealPaytype(balanceMonth);
        double monthTotalPayAmt = 0.0;
        double monthTotalSettleAmt = 0.0;
        for (HashMap<String, Object> paytypeAndRealPaytypeMap : biznoAndPaytypeAndRealPaytypeList) {
            try {
                String paytype = paytypeAndRealPaytypeMap.get("paytype").toString();
                String realPaytype = paytypeAndRealPaytypeMap.get("realpaytype").toString();
                HashMap<String, Object> resultMap = this.leiMonthReportDao.queryMonthSum(balanceMonth, paytype, realPaytype);
                double totalPayAmt = Double.parseDouble(resultMap.get("totalpayamt").toString());
                double totalSettleAmt = Double.parseDouble(resultMap.get("totalsettleamt").toString());
                Double totalRealAmt = 0.0;
                totalRealAmt = totalSettleAmt;
                if ("1".equals(this.leiPaytypeinfoCache.getPaytypeinfo(paytype).get("inrealrate"))) {
                    monthTotalPayAmt = Arith.add(monthTotalPayAmt, totalPayAmt);
                    monthTotalSettleAmt = Arith.add(monthTotalSettleAmt, totalSettleAmt);
                }
                this.leiMonthReportDao.insert(balanceMonth, paytype, realPaytype, totalPayAmt, totalSettleAmt, totalRealAmt);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        double realpercent = 0.0;
        if (monthTotalPayAmt != 0.0) {
            realpercent = Arith.div(monthTotalSettleAmt, monthTotalPayAmt, 5);
        }
        this.incomePaytypeinfoDao.updateRate("A", "A", realpercent);
        this.incomePaytypeinfoDao.updateRate("A1", "A", realpercent);
        this.incomePaytypeinfoCache.reload();
    }

    public void singleStatisticsByPaytype(String balanceMonth, String paytype) {
        Map<String, String> reportSqlMap = this.leiReportsqlCache.getInstance();
        if (!reportSqlMap.containsKey(paytype)) {
            log.error("cant find a sql for paytype:{}", new Object[]{paytype});
            return;
        }
        this.leiMonthReportDao.deleteByPaytype(balanceMonth, paytype);
        List<String> realPaytypeList = this.leiMonthReportDao.getDistinctRealPaytypeByPaytype(balanceMonth, paytype);
        log.debug("realPaytypeList size:{}", (Object)realPaytypeList.size());
        for (String realPaytype : realPaytypeList) {
            HashMap<String, Object> resultMap = this.leiMonthReportDao.queryMonthSum(balanceMonth, paytype, realPaytype);
            double totalPayAmt = Double.parseDouble(resultMap.get("totalpayamt").toString());
            double totalSettleAmt = Double.parseDouble(resultMap.get("totalsettleamt").toString());
            Double totalRealAmt = 0.0;
            totalRealAmt = totalSettleAmt;
            this.leiMonthReportDao.insert(balanceMonth, paytype, realPaytype, totalPayAmt, totalSettleAmt, totalRealAmt);
        }
    }
}

