/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.bo;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.LeiDayReportDao;
import com.xunlei.channel.channelreport.statistics.cache.LeiPaytypeinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.LeiReportsqlCache;
import com.xunlei.channel.channelreport.util.Arith;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiDayReportBo {
    private static final Logger log = LoggerFactory.getLogger(LeiDayReportBo.class);
    @Autowired
    LeiReportsqlCache leiReportsqlCache;
    @Autowired
    LeiDayReportDao leiDayReportDao;
    @Autowired
    LeiPaytypeinfoCache leiPaytypeinfoCache;

    public void allStatistics(String balanceDate) throws Exception {
        this.leiDayReportDao.deleteByBalanceDate(balanceDate);
        Map<String, String> reportSqlMap = this.leiReportsqlCache.getInstance();
        for (Map.Entry<String, String> entry : reportSqlMap.entrySet()) {
            String paytype = entry.getKey();
            double payAmt = 0.0;
            String paySql = reportSqlMap.get(paytype);
            log.debug("begin statistics day_lei,balancedate:{},sql:{}", new Object[]{balanceDate, paySql});
            if (!Strings.isNullOrEmpty((String)paySql)) {
                payAmt = this.leiDayReportDao.queryOrderAmtSumByBalanceDate(paySql, balanceDate);
            }
            String realPaytype = this.leiPaytypeinfoCache.getPaytypeinfo(paytype).get("realpaytype").toString();
            String rateString = this.leiPaytypeinfoCache.getPaytypeinfo(realPaytype).get("rate").toString();
            double rate = Double.valueOf(rateString);
            double settleAmt = Arith.mul(payAmt, rate);
            this.leiDayReportDao.insert(balanceDate, paytype, realPaytype, payAmt, settleAmt);
        }
    }

    public String singleStatisticsByPaytype(String balanceDate, String paytype) throws Exception {
        Map<String, Object> paytypeInfo = this.leiPaytypeinfoCache.getPaytypeinfo(paytype);
        if (null == paytypeInfo) {
            log.warn("invalid paytype:{}", (Object)paytype);
            return "invalid paytype";
        }
        if (!paytypeInfo.containsKey("realpaytype")) {
            log.info("cannot find realpaytype param of paytype:{}", (Object)paytype);
            return "no realpaytype found";
        }
        String realPaytype = paytypeInfo.get("realpaytype").toString();
        Map<String, Object> realPaytypeInfo = this.leiPaytypeinfoCache.getPaytypeinfo(realPaytype);
        if (null == realPaytypeInfo) {
            log.warn("invalid realPaytype:{}", (Object)realPaytype);
            return "invalid realPaytype";
        }
        if (!realPaytypeInfo.containsKey("rate")) {
            log.warn("no rate found for realPaytype:{}", (Object)realPaytype);
            return "not rate found for realPaytype:" + realPaytype;
        }
        String rateString = realPaytypeInfo.get("rate").toString();
        this.leiDayReportDao.deleteByPaytype(balanceDate, paytype);
        Map<String, String> reportSqlMap = this.leiReportsqlCache.getInstance();
        String paySql = reportSqlMap.get(paytype);
        double payAmt = 0.0;
        double settleAmt = 0.0;
        if (!Strings.isNullOrEmpty((String)paySql)) {
            payAmt = this.leiDayReportDao.queryOrderAmtSumByBalanceDate(paySql, balanceDate);
        }
        double rate = Double.valueOf(rateString);
        settleAmt = Arith.mul(payAmt, rate);
        this.leiDayReportDao.insert(balanceDate, paytype, realPaytype, payAmt, settleAmt);
        return "success";
    }
}

