/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.bo;

import com.xunlei.channel.channelreport.dao.IncomeManMonthReportDao;
import com.xunlei.channel.channelreport.dao.IncomeMonthReportDao;
import com.xunlei.channel.channelreport.statistics.cache.IncomeBizinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomeReportsqlCache;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import com.xunlei.channel.channelreport.vo.MonthReport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthReportBo {
    private static final Logger log = LoggerFactory.getLogger(IncomeMonthReportBo.class);
    @Autowired
    IncomeReportsqlCache incomeReportsqlCache;
    @Autowired
    IncomeBizinfoCache incomeBizinfoCache;
    @Autowired
    IncomePaytypeinfoCache incomePaytypecCache;
    @Autowired
    IncomeMonthReportDao incomeMonthReportDao;
    @Autowired
    IncomePaytypeinfoCache incomePaytypeinfoCache;
    @Autowired
    IncomeManMonthReportDao incomeManMonthReportDao;

    public void allStatistics(String balanceMonth) {
        this.incomeMonthReportDao.deleteByBalanceMonth(balanceMonth);
        Map<String, Double> manMonthhReportMapList = this.incomeManMonthReportDao.getAmtMapByMonth(balanceMonth);
        LinkedList<MonthReport> allList = new LinkedList<MonthReport>();
        List<MonthReport> monthReportList = this.incomeMonthReportDao.getMonthReportList(balanceMonth);
        HashSet<String> doneSet = new HashSet<String>();
        for (Map.Entry<String, Double> entry : manMonthhReportMapList.entrySet()) {
            String[] temp = entry.getKey().split("_");
            String bizno = temp[0];
            String paytype = temp[1];
            String realPaytype = temp[2];
            if (doneSet.contains(bizno + "_" + paytype)) continue;
            Double totalPayAmt = 0.0;
            Double totalSettleAmt = 0.0;
            Double totalRefundAmt = 0.0;
            Double totalRealAmt = 0.0;
            String paytypeAndType = IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A");
            Map<String, Object> paytypeinfo = this.incomePaytypeinfoCache.getPaytypeinfo(paytypeAndType);
            String stasticsAmtFrom = (String)paytypeinfo.get("stasticsamtfrom");
            if (!"M".equals(stasticsAmtFrom)) continue;
            totalRealAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"));
            totalPayAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"));
            totalSettleAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"));
            totalRefundAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"));
            if (totalRealAmt == null) {
                totalRealAmt = 0.0;
            }
            if (totalPayAmt == null) {
                totalPayAmt = 0.0;
            }
            if (totalSettleAmt == null) {
                totalSettleAmt = 0.0;
            }
            if (totalRefundAmt == null) {
                totalRefundAmt = 0.0;
            }
            MonthReport monthReport = new MonthReport();
            monthReport.setBalanceMonth(balanceMonth);
            monthReport.setBizno(bizno);
            monthReport.setPayAmt(totalPayAmt);
            monthReport.setPaytype(realPaytype);
            monthReport.setRealamt(totalRealAmt);
            monthReport.setRealpaytype(realPaytype);
            monthReport.setRefundamt(totalRefundAmt);
            monthReport.setSettleamt(totalSettleAmt);
            allList.add(monthReport);
            doneSet.add(bizno + "_" + paytype);
        }
        for (MonthReport monthReport : monthReportList) {
            if (doneSet.contains(monthReport.getBizno() + "_" + monthReport.getPaytype())) continue;
            String realPaytype = monthReport.getPaytype();
            Map<String, Object> paytypeInfo = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(monthReport.getPaytype(), "A"));
            if (null != paytypeInfo) {
                realPaytype = paytypeInfo.get("realpaytype").toString();
            }
            monthReport.setRealpaytype(realPaytype);
            allList.add(monthReport);
        }
        this.incomeMonthReportDao.bathInsertMonthReport(allList);
    }

    public void singleStatisticsByBizno(String balanceMonth, String resetBizno) {
        this.incomeMonthReportDao.deleteByBizno(balanceMonth, resetBizno);
        Map<String, Double> manMonthhReportMapList = this.incomeManMonthReportDao.getAmtMapByMonthAndBizno(balanceMonth, resetBizno);
        List<HashMap<String, Object>> biznoAndPaytypeAndRealPaytypeList = this.incomeMonthReportDao.getDistinctPaytypeAndRealPaytypeByBizno(balanceMonth, resetBizno);
        for (HashMap<String, Object> biznoAndPaytypeMap : biznoAndPaytypeAndRealPaytypeList) {
            try {
                String bizno = biznoAndPaytypeMap.get("bizno").toString();
                String paytype = biznoAndPaytypeMap.get("paytype").toString();
                String realPaytype = biznoAndPaytypeMap.get("realpaytype").toString();
                Map<String, Object> resultMap = this.incomeMonthReportDao.queryMonthSum(balanceMonth, paytype, realPaytype, bizno);
                Double totalPayAmt = 0.0;
                Double totalSettleAmt = 0.0;
                Double totalRefundAmt = 0.0;
                Double totalRealAmt = 0.0;
                String stasticsAmtFrom = (String)this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A")).get("stasticsamtfrom");
                if ("M".equals(stasticsAmtFrom)) {
                    totalRealAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"));
                    totalPayAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"));
                    totalSettleAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"));
                    totalRefundAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"));
                    if (totalRealAmt == null) {
                        totalRealAmt = 0.0;
                    }
                    if (totalPayAmt == null) {
                        totalPayAmt = 0.0;
                    }
                    if (totalSettleAmt == null) {
                        totalSettleAmt = 0.0;
                    }
                    if (totalRefundAmt == null) {
                        totalRefundAmt = 0.0;
                    }
                } else {
                    totalPayAmt = Double.parseDouble(resultMap.get("totalpayamt").toString());
                    totalSettleAmt = Double.parseDouble(resultMap.get("totalsettleamt").toString());
                    totalRefundAmt = Double.parseDouble(resultMap.get("totalrefundamt").toString());
                    totalRealAmt = totalSettleAmt;
                }
                this.incomeMonthReportDao.insert(balanceMonth, bizno, paytype, realPaytype, totalPayAmt, totalSettleAmt, totalRefundAmt, totalRealAmt);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void singleStatisticsByPaytype(String balanceMonth, String paytype) {
        this.incomeMonthReportDao.deleteByPaytype(balanceMonth, paytype);
        List<String> biznoList = this.incomeMonthReportDao.getDistinctBizno(balanceMonth);
        List<String> realPaytypeList = this.incomeMonthReportDao.getDistinctRealPaytypeByPaytype(balanceMonth, paytype);
        Map<String, String> reportSqlMap = this.incomeReportsqlCache.getInstance();
        String realAmtFrom = (String)this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A")).get("stasticsamtfrom");
        Map<String, Double> manMonthhReportMapList = this.incomeManMonthReportDao.getAmtMapByMonth(balanceMonth);
        for (String bizno : biznoList) {
            if (!reportSqlMap.containsKey(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "A"))) {
                log.error("cant find a sql for bizno:{},paytype:{}", new Object[]{bizno, paytype});
                continue;
            }
            for (String realPaytype : realPaytypeList) {
                Double totalPayAmt = 0.0;
                Double totalSettleAmt = 0.0;
                Double totalRefundAmt = 0.0;
                Double totalRealAmt = 0.0;
                Map<String, Object> resultMap = this.incomeMonthReportDao.queryMonthSum(balanceMonth, paytype, realPaytype, bizno);
                if ("M".equals(realAmtFrom)) {
                    totalRealAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"));
                    totalPayAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"));
                    totalSettleAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"));
                    totalRefundAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"));
                    if (totalRealAmt == null) {
                        totalRealAmt = 0.0;
                    }
                    if (totalPayAmt == null) {
                        totalPayAmt = 0.0;
                    }
                    if (totalSettleAmt == null) {
                        totalSettleAmt = 0.0;
                    }
                    if (totalRefundAmt == null) {
                        totalRefundAmt = 0.0;
                    }
                } else {
                    totalPayAmt = Double.parseDouble(resultMap.get("totalpayamt").toString());
                    totalSettleAmt = Double.parseDouble(resultMap.get("totalsettleamt").toString());
                    totalRefundAmt = Double.parseDouble(resultMap.get("totalrefundamt").toString());
                    totalRealAmt = totalSettleAmt;
                }
                this.incomeMonthReportDao.insert(balanceMonth, bizno, paytype, realPaytype, totalPayAmt, totalSettleAmt, totalRefundAmt, totalRealAmt);
            }
        }
    }

    public void singleStatisticsByBiznoAndPaytype(String balanceMonth, String bizno, String paytype) {
        this.incomeMonthReportDao.deleteByBiznoAndPaytype(balanceMonth, bizno, paytype);
        List<String> realPaytypeList = this.incomeMonthReportDao.getDistinctRealPaytypeByPaytype(balanceMonth, paytype);
        Map<String, String> reportSqlMap = this.incomeReportsqlCache.getInstance();
        String realAmtFrom = (String)this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A")).get("stasticsamtfrom");
        Map<String, Double> manMonthhReportMapList = this.incomeManMonthReportDao.getAmtMapByMonth(balanceMonth);
        if (!reportSqlMap.containsKey(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "A"))) {
            log.error("cant find a sql for bizno:{},paytype:{}", new Object[]{bizno, paytype});
            return;
        }
        for (String realPaytype : realPaytypeList) {
            Double totalPayAmt = 0.0;
            Double totalSettleAmt = 0.0;
            Double totalRefundAmt = 0.0;
            Double totalRealAmt = 0.0;
            Map<String, Object> resultMap = this.incomeMonthReportDao.queryMonthSum(balanceMonth, paytype, realPaytype, bizno);
            if ("M".equals(realAmtFrom)) {
                totalRealAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"));
                totalPayAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"));
                totalSettleAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"));
                totalRefundAmt = manMonthhReportMapList.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"));
                if (totalRealAmt == null) {
                    totalRealAmt = 0.0;
                }
                if (totalPayAmt == null) {
                    totalPayAmt = 0.0;
                }
                if (totalSettleAmt == null) {
                    totalSettleAmt = 0.0;
                }
                if (totalRefundAmt == null) {
                    totalRefundAmt = 0.0;
                }
            } else {
                totalPayAmt = Double.parseDouble(resultMap.get("totalpayamt").toString());
                totalSettleAmt = Double.parseDouble(resultMap.get("totalsettleamt").toString());
                totalRefundAmt = Double.parseDouble(resultMap.get("totalrefundamt").toString());
                totalRealAmt = totalSettleAmt;
            }
            this.incomeMonthReportDao.insert(balanceMonth, bizno, paytype, realPaytype, totalPayAmt, totalSettleAmt, totalRefundAmt, totalRealAmt);
        }
    }
}

