/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.statistics.bo;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.IncomeDayReportDao;
import com.xunlei.channel.channelreport.statistics.cache.IncomeBizinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomeReportsqlCache;
import com.xunlei.channel.channelreport.util.Arith;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayReportBo {
    private static final Logger logger = LoggerFactory.getLogger(IncomeDayReportBo.class);
    @Autowired
    IncomeReportsqlCache incomeReportsqlCache;
    @Autowired
    IncomeDayReportDao incomeDayReportDao;
    @Autowired
    IncomeBizinfoCache incomeBizinfoCache;
    @Autowired
    IncomePaytypeinfoCache incomePaytypeinfoCache;

    public void allStatistics2(String balanceDate) throws Exception {
        this.incomeDayReportDao.deleteByBalanceDate(balanceDate);
        Map<String, String> manSqlMap = this.incomeReportsqlCache.getManSqlMap();
        Map<String, Double> payAmtMap = this.incomeDayReportDao.getDayBizPaytypeOrderamt(balanceDate);
        logger.info("BalanceDate: {}, Man sql map: {}", (Object)balanceDate, manSqlMap);
        logger.info("BalanceDate: {}, Pay amt map: {}", (Object)balanceDate, payAmtMap);
        HashSet<String> theSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : manSqlMap.entrySet()) {
            String payuserSql;
            if (!entry.getKey().endsWith("A")) continue;
            logger.info("do manSql for:{}", (Object)entry.getKey());
            String biznoAndPaytypeAndType = entry.getKey();
            String[] bizno_paytype_type = IncomeReportStatisticsUtil.splitBiznoAndPaytypeAndType(biznoAndPaytypeAndType);
            if (bizno_paytype_type.length != 3) {
                logger.error("error biznoAndPaytypeAndType:{}", (Object)biznoAndPaytypeAndType);
                continue;
            }
            String bizno = bizno_paytype_type[0];
            String paytype = bizno_paytype_type[1];
            String type = bizno_paytype_type[2];
            double payAmt = 0.0;
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            String paySql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "A"));
            if (!Strings.isNullOrEmpty((String)paySql)) {
                payAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(paySql, balanceDate);
            }
            String realPaytype = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type)).get("realpaytype").toString();
            String rateString = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(realPaytype, type)).get("rate").toString();
            double rate = Double.valueOf(rateString);
            double settleAmt = Arith.mul(payAmt, rate);
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
            theSet.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : payAmtMap.entrySet()) {
            String payuserSql;
            double settleAmt;
            double rate;
            String realPaytype;
            if (theSet.contains(entry.getKey())) {
                logger.info("manSql has been done for:{},ignore now", (Object)entry.getKey());
                continue;
            }
            String[] bizAndPaytype = entry.getKey().split("_");
            String bizNo = bizAndPaytype[0];
            String paytype = bizAndPaytype[1];
            String type = bizAndPaytype[2];
            double payAmt = (Double)entry.getValue();
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            Map<String, Object> paytypeInfo = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type));
            if (null != paytypeInfo) {
                realPaytype = paytypeInfo.get("realpaytype").toString();
                String rateString = paytypeInfo.get("rate").toString();
                rate = Double.valueOf(rateString);
                settleAmt = Arith.mul(payAmt, rate);
            } else {
                logger.error("No paytypeInfo found for:{}", (Object)paytype);
                rate = 1.0;
                settleAmt = payAmt;
                realPaytype = paytype;
            }
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizNo, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizNo, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizNo, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
        }
    }

    public void singleStatisticsByPaytype(String balanceDate, String paytype) throws Exception {
        this.incomeDayReportDao.deleteByPaytype(balanceDate, paytype);
        Map<String, String> manSqlMap = this.incomeReportsqlCache.getManSqlMap();
        Map<String, Double> bizPayAmtMap = this.incomeDayReportDao.getDayPaytypeOrderamt(balanceDate, paytype);
        HashSet<String> bizSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : manSqlMap.entrySet()) {
            String payuserSql;
            if (!entry.getKey().endsWith("_" + paytype + "_" + "A")) continue;
            logger.info("do manSql for:{}", (Object)entry.getKey());
            String biznoAndPaytypeAndType = entry.getKey();
            String[] bizno_paytype_type = IncomeReportStatisticsUtil.splitBiznoAndPaytypeAndType(biznoAndPaytypeAndType);
            if (bizno_paytype_type.length != 3) {
                logger.error("error biznoAndPaytypeAndType:{}", (Object)biznoAndPaytypeAndType);
                continue;
            }
            String bizno = bizno_paytype_type[0];
            String type = bizno_paytype_type[2];
            double payAmt = 0.0;
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            String paySql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "A"));
            if (!Strings.isNullOrEmpty((String)paySql)) {
                payAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(paySql, balanceDate);
            }
            String realPaytype = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type)).get("realpaytype").toString();
            String rateString = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(realPaytype, type)).get("rate").toString();
            double rate = Double.valueOf(rateString);
            double settleAmt = Arith.mul(payAmt, rate);
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
            bizSet.add(bizno);
        }
        for (Map.Entry<String, Object> entry : bizPayAmtMap.entrySet()) {
            String payuserSql;
            double settleAmt;
            double rate;
            String realPaytype;
            if (bizSet.contains(entry.getKey())) continue;
            String bizNo = entry.getKey();
            String type = "A";
            double payAmt = 0.0;
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            payAmt = (Double)entry.getValue();
            Map<String, Object> paytypeInfo = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type));
            if (null != paytypeInfo) {
                realPaytype = paytypeInfo.get("realpaytype").toString();
                String rateString = paytypeInfo.get("rate").toString();
                rate = Double.valueOf(rateString);
                settleAmt = Arith.mul(payAmt, rate);
            } else {
                logger.error("No paytypeInfo found for:{}", (Object)paytype);
                rate = 1.0;
                settleAmt = payAmt;
                realPaytype = paytype;
            }
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizNo, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizNo, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizNo, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
        }
    }

    public void singleStatisticsByBizno(String balanceDate, String bizno) throws Exception {
        this.incomeDayReportDao.deleteByBizno(balanceDate, bizno);
        Map<String, String> manSqlMap = this.incomeReportsqlCache.getManSqlMap();
        Map<String, Double> paytypePayAmtMap = this.incomeDayReportDao.getDayBizOrderamt(balanceDate, bizno);
        HashSet<String> paytypeSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : manSqlMap.entrySet()) {
            String payuserSql;
            if (!entry.getKey().startsWith(bizno + "_") || !entry.getKey().endsWith("_A")) continue;
            logger.info("do manSql for:{}", (Object)entry.getKey());
            String biznoAndPaytypeAndType = entry.getKey();
            String[] bizno_paytype_type = IncomeReportStatisticsUtil.splitBiznoAndPaytypeAndType(biznoAndPaytypeAndType);
            if (bizno_paytype_type.length != 3) {
                logger.error("error biznoAndPaytypeAndType:{}", (Object)biznoAndPaytypeAndType);
                continue;
            }
            String paytype = bizno_paytype_type[1];
            String type = bizno_paytype_type[2];
            double payAmt = 0.0;
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            String paySql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "A"));
            if (!Strings.isNullOrEmpty((String)paySql)) {
                payAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(paySql, balanceDate);
            }
            String realPaytype = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type)).get("realpaytype").toString();
            String rateString = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(realPaytype, type)).get("rate").toString();
            double rate = Double.valueOf(rateString);
            double settleAmt = Arith.mul(payAmt, rate);
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
            paytypeSet.add(paytype);
        }
        for (Map.Entry<String, Object> entry : paytypePayAmtMap.entrySet()) {
            String payuserSql;
            double settleAmt;
            double rate;
            String realPaytype;
            if (paytypeSet.contains(entry.getKey())) continue;
            String paytype = entry.getKey();
            String type = "A";
            double payAmt = 0.0;
            double refundAmt = 0.0;
            double payuserAmt = 0.0;
            payAmt = (Double)entry.getValue();
            Map<String, Object> paytypeInfo = this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, type));
            if (null != paytypeInfo) {
                realPaytype = paytypeInfo.get("realpaytype").toString();
                String rateString = paytypeInfo.get("rate").toString();
                rate = Double.valueOf(rateString);
                settleAmt = Arith.mul(payAmt, rate);
            } else {
                logger.error("No paytypeInfo found for:{}", (Object)paytype);
                rate = 1.0;
                settleAmt = payAmt;
                realPaytype = paytype;
            }
            String refundSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "D"));
            if (!Strings.isNullOrEmpty((String)refundSql)) {
                refundAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(refundSql, balanceDate);
            }
            if (!Strings.isNullOrEmpty((String)(payuserSql = manSqlMap.get(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndType(bizno, paytype, "E"))))) {
                payuserAmt = this.incomeDayReportDao.queryOrderAmtSumByBalanceDate(payuserSql, balanceDate);
            }
            this.incomeDayReportDao.insert(balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt);
        }
    }
}

