/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.xunlei.channel.channelreport.repo.bo.LeiMonthRepoTableBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthRepoTableCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(LeiMonthRepoTableCmd.class);
    @Autowired
    LeiMonthRepoTableBo leiMonthRepoTableBo;

    @CmdMapper(value={"/leiMonthRepoTable"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int fromLevel = request.getParameterInteger("fromlevel");
        int toLevel = request.getParameterInteger("tolevel");
        String fromMonth = request.getParameterCompelled("frommonth");
        String toMonth = request.getParameterCompelled("tomonth");
        String paytypeCode = request.getParameter("paytypecode");
        if (fromLevel > toLevel) {
            throw new IllegalParameterError("fromlevel&tolevel", request, "String", "fromlevel need little than tolevel");
        }
        if (fromMonth.length() != 7) {
            throw new IllegalParameterError("frommonth", request, "String");
        }
        if (toMonth.length() != 7) {
            throw new IllegalParameterError("tomonth", request, "String");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        return this.leiMonthRepoTableBo.createTableHeader(fromLevel, toLevel, fromMonth, toMonth, paytypeCode);
    }
}

