/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.xunlei.channel.channelreport.repo.bo.LeiMonthRepoDataBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthRepoDataCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(LeiMonthRepoDataCmd.class);
    @Autowired
    LeiMonthRepoDataBo leiMonthRepoDataBo;

    @CmdMapper(value={"/leiMonthRepoData"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int bottomLevel = request.getParameterInteger("bottomlevel");
        String balanceFromMonth = request.getParameterCompelled("frommonth");
        String balanceToMonth = request.getParameterCompelled("tomonth");
        int pageNo = request.getParameterInteger("pageno");
        int pageSize = request.getParameterInteger("pagesize");
        String paytypeCode = request.getParameter("paytypecode");
        if (balanceFromMonth.length() != 7) {
            throw new IllegalParameterError("frommonth", request, "String");
        }
        if (balanceToMonth.length() != 7) {
            throw new IllegalParameterError("tomonth", request, "String");
        }
        if (pageNo <= 0) {
            throw new IllegalParameterError("pageno", request, "Integer", "cant little than 0");
        }
        if (pageSize <= 0) {
            throw new IllegalParameterError("pagesize", request, "Integer", "cant little than 0");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        return this.leiMonthRepoDataBo.getMonthRepoData(bottomLevel, balanceFromMonth, balanceToMonth, paytypeCode, pageNo, pageSize);
    }
}

