/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.xunlei.channel.channelreport.repo.bo.LeiDayRepoDataBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiDayRepoDataCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(LeiDayRepoDataCmd.class);
    @Autowired
    LeiDayRepoDataBo leiDayRepoDataBo;

    @CmdMapper(value={"/leiDayRepoData"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int bottomLevel = request.getParameterInteger("bottomlevel");
        String balanceFromDate = request.getParameterCompelled("fromdate");
        String balanceToDate = request.getParameterCompelled("todate");
        int pageNo = request.getParameterInteger("pageno");
        int pageSize = request.getParameterInteger("pagesize");
        String paytypeCode = request.getParameter("paytypecode");
        if (balanceFromDate.length() != 10) {
            throw new IllegalParameterError("fromdate", request, "String");
        }
        if (balanceToDate.length() != 10) {
            throw new IllegalParameterError("todate", request, "String");
        }
        if (pageNo <= 0) {
            throw new IllegalParameterError("pageno", request, "Integer", "cant little than 0");
        }
        if (pageSize <= 0) {
            throw new IllegalParameterError("pagesize", request, "Integer", "cant little than 0");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        return this.leiDayRepoDataBo.getDayRepoData(bottomLevel, balanceFromDate, balanceToDate, paytypeCode, pageNo, pageSize);
    }
}

