/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.cache.IncomePaytypeMenuCache;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.json.JSONUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomePaytypeMenuCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(IncomePaytypeMenuCmd.class);
    @Autowired
    private IncomePaytypeMenuCache incomePaytypeMenuCache;

    @CmdMapper(value={"/incomePaytypeMenuCmd"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String parentCode = request.getParameter("parentCode");
        String bizCode = request.getParameter("bizCode");
        log.info("bizCode:{},parentCode:{}", (Object)bizCode, (Object)parentCode);
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        if (null == parentCode) {
            parentCode = "";
        }
        if (Strings.isNullOrEmpty((String)bizCode)) {
            List<IncomePaytypeMenu> children = this.incomePaytypeMenuCache.getChildrenInfo().get(parentCode);
            if (null == children) {
                children = new ArrayList<IncomePaytypeMenu>();
            }
            return JSONUtil.fromObject(children);
        }
        Map<String, List<IncomePaytypeMenu>> bizMap = this.incomePaytypeMenuCache.getBizPaytypeMenuMap().get(bizCode);
        if (null == bizMap) {
            return JSONUtil.fromObject(new ArrayList());
        }
        List<IncomePaytypeMenu> children = bizMap.get(parentCode);
        if (null == children) {
            children = new ArrayList<IncomePaytypeMenu>();
        }
        return JSONUtil.fromObject(children);
    }
}

