/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.bo.IncomeMonthRepoDataBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthRepoDataCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(IncomeMonthRepoDataCmd.class);
    @Autowired
    IncomeMonthRepoDataBo incomeMonthRepoDataBo;

    @CmdMapper(value={"/incomeMonthRepoData"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int bottomLevel = request.getParameterInteger("bottomlevel");
        String balanceFromMonth = request.getParameterCompelled("frommonth");
        String balanceToMonth = request.getParameterCompelled("tomonth");
        String bizCode = request.getParameter("bizcode");
        int pageNo = request.getParameterInteger("pageno");
        int pageSize = request.getParameterInteger("pagesize");
        String paytypeCode = request.getParameter("paytypecode");
        log.debug("bizCode:{},paytypeCode:{},fromMonth:{},toMonth:{}", new Object[]{bizCode, paytypeCode, balanceFromMonth, balanceToMonth});
        if (balanceFromMonth.length() != 7) {
            throw new IllegalParameterError("frommonth", request, "String");
        }
        if (balanceToMonth.length() != 7) {
            throw new IllegalParameterError("tomonth", request, "String");
        }
        if (pageNo <= 0) {
            throw new IllegalParameterError("pageno", request, "Integer", "cant little than 0");
        }
        if (pageSize <= 0) {
            throw new IllegalParameterError("pagesize", request, "Integer", "cant little than 0");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        if (Strings.isNullOrEmpty((String)bizCode)) {
            return this.incomeMonthRepoDataBo.getBizMonthRepoData(bottomLevel, balanceFromMonth, balanceToMonth, bizCode, paytypeCode, pageNo, pageSize);
        }
        return this.incomeMonthRepoDataBo.getBizMonthRepoData(bottomLevel, balanceFromMonth, balanceToMonth, bizCode, paytypeCode, pageNo, pageSize);
    }
}

