/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.bo.IncomeDayRepoTableBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayRepoTableCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(IncomeDayRepoTableCmd.class);
    @Autowired
    IncomeDayRepoTableBo incomeDayRepoTableBo;

    @CmdMapper(value={"/incomeDayRepoTable"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int fromLevel = request.getParameterInteger("fromlevel");
        int toLevel = request.getParameterInteger("tolevel");
        String fromDate = request.getParameterCompelled("fromdate");
        String toDate = request.getParameterCompelled("todate");
        String bizCode = request.getParameter("bizcode");
        String paytypeCode = request.getParameter("paytypecode");
        log.info("dayRepoTable...fromlevel:{},tolevel:{},fromdate:{},todate:{},bizcode:{},paytypecode:{}", new Object[]{fromLevel, toLevel, fromDate, toDate, bizCode, paytypeCode});
        if (fromLevel > toLevel) {
            throw new IllegalParameterError("fromlevel&tolevel", request, "String", "fromlevel need little than tolevel");
        }
        if (fromDate.length() != 10) {
            throw new IllegalParameterError("fromdate", request, "String");
        }
        if (toDate.length() != 10) {
            throw new IllegalParameterError("todate", request, "String");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        if (Strings.isNullOrEmpty((String)bizCode)) {
            return this.incomeDayRepoTableBo.createBizTableHeader(fromLevel, toLevel, fromDate, toDate, bizCode, paytypeCode);
        }
        return this.incomeDayRepoTableBo.createBizTableHeader(fromLevel, toLevel, fromDate, toDate, bizCode, paytypeCode);
    }
}

