/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cmd;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.bo.IncomeDayRepoDataBo;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.httptool.login.DefaultCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayRepoDataCmd
extends DefaultCmd {
    private static Logger log = LoggerFactory.getLogger(IncomeDayRepoDataCmd.class);
    @Autowired
    IncomeDayRepoDataBo incomeDayRepoDataBo;

    @CmdMapper(value={"/incomeDayRepoData"})
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int bottomLevel = request.getParameterInteger("bottomlevel");
        String balanceFromDate = request.getParameterCompelled("fromdate");
        String balanceToDate = request.getParameterCompelled("todate");
        String bizCode = request.getParameter("bizcode");
        int pageNo = request.getParameterInteger("pageno");
        int pageSize = request.getParameterInteger("pagesize");
        String paytypeCode = request.getParameter("paytypecode");
        log.debug("fromdate:{},todate:{},bizcode:{},paytypecode:{},bottomlevel:{},pageno:{},pagesize:{}", new Object[]{balanceFromDate, balanceToDate, bizCode, paytypeCode, bottomLevel, pageNo, pageSize});
        if (balanceFromDate.length() != 10) {
            throw new IllegalParameterError("fromdate", request, "String");
        }
        if (balanceToDate.length() != 10) {
            throw new IllegalParameterError("todate", request, "String");
        }
        if (pageNo <= 0) {
            throw new IllegalParameterError("pageno", request, "Integer", "cant little than 0");
        }
        if (pageSize <= 0) {
            throw new IllegalParameterError("pagesize", request, "Integer", "cant little than 0");
        }
        response.setContentCharset(ReportRepoUtil.DEFAULT_CHARSET);
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        if (Strings.isNullOrEmpty((String)bizCode)) {
            return this.incomeDayRepoDataBo.getBizDayRepoData(bottomLevel, balanceFromDate, balanceToDate, bizCode, paytypeCode, pageNo, pageSize);
        }
        return this.incomeDayRepoDataBo.getBizDayRepoData(bottomLevel, balanceFromDate, balanceToDate, bizCode, paytypeCode, pageNo, pageSize);
    }
}

