/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cache;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.LeiPaytypeMenuDao;
import com.xunlei.channel.channelreport.vo.LeiPaytypeMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiPaytypeMenuCache {
    public static final Logger log = LoggerFactory.getLogger(LeiPaytypeMenuCache.class);
    @Autowired
    LeiPaytypeMenuDao leiPaytypeMenuDao;
    private Map<String, LeiPaytypeMenu> paytypeMenuInfo = new HashMap<String, LeiPaytypeMenu>();
    private Map<String, List<String>> parentInfo = new HashMap<String, List<String>>();
    private Map<String, Set<String>> fieldPaytypeInfo = new HashMap<String, Set<String>>();
    private Map<String, List<LeiPaytypeMenu>> childrenInfo = new HashMap<String, List<LeiPaytypeMenu>>();

    public void reload() {
        HashMap<String, LeiPaytypeMenu> paytypeMenuInfoTmp = new HashMap<String, LeiPaytypeMenu>();
        HashMap<String, List<String>> parentInfoTmp = new HashMap<String, List<String>>();
        HashMap<String, Set<String>> fieldPaytypeInfoTmp = new HashMap<String, Set<String>>();
        HashMap<String, ArrayList<LeiPaytypeMenu>> childrenInfoTmp = new HashMap<String, ArrayList<LeiPaytypeMenu>>();
        List<HashMap<String, Object>> paytypeMenuMapList = this.leiPaytypeMenuDao.getPaytypeMenuMapList("filedcode");
        for (HashMap<String, Object> hashMap : paytypeMenuMapList) {
            String fieldCode = hashMap.get("fieldcode").toString();
            short level = Short.valueOf(hashMap.get("level").toString());
            String parentCode = hashMap.get("parentcode").toString();
            String paytype = hashMap.get("paytype").toString();
            String name = hashMap.get("name").toString();
            int seqId = Integer.valueOf(hashMap.get("seqid").toString());
            LeiPaytypeMenu paytypeMenu = new LeiPaytypeMenu(seqId, name, fieldCode, parentCode, level, paytype);
            paytypeMenuInfoTmp.put(paytypeMenu.getFieldcode(), paytypeMenu);
            if (!Strings.isNullOrEmpty((String)parentCode)) {
                ArrayList<String> childrenList = (ArrayList<String>)parentInfoTmp.get(parentCode);
                if (childrenList == null) {
                    childrenList = new ArrayList<String>();
                }
                childrenList.add(fieldCode);
                parentInfoTmp.put(parentCode, childrenList);
                ArrayList<LeiPaytypeMenu> children = (ArrayList<LeiPaytypeMenu>)childrenInfoTmp.get(parentCode);
                if (null == children) {
                    children = new ArrayList<LeiPaytypeMenu>();
                }
                children.add(paytypeMenu);
                childrenInfoTmp.put(parentCode, children);
                continue;
            }
            ArrayList<LeiPaytypeMenu> children = (ArrayList<LeiPaytypeMenu>)childrenInfoTmp.get("");
            if (null == children) {
                children = new ArrayList<LeiPaytypeMenu>();
            }
            children.add(paytypeMenu);
            childrenInfoTmp.put("", children);
        }
        this.childrenInfo = Collections.unmodifiableMap(childrenInfoTmp);
        this.paytypeMenuInfo = Collections.unmodifiableMap(paytypeMenuInfoTmp);
        for (String string : this.paytypeMenuInfo.keySet()) {
            ArrayList<String> parentCode = new ArrayList<String>();
            parentCode.add(string);
            Set<String> paytypes = this.getAllChildrenPaytype(parentInfoTmp, parentCode, new HashSet<String>());
            fieldPaytypeInfoTmp.put(string, Collections.unmodifiableSet(paytypes));
        }
        for (Map.Entry entry : parentInfoTmp.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            parentInfoTmp.put(key, Collections.unmodifiableList(value));
        }
        this.parentInfo = Collections.unmodifiableMap(parentInfoTmp);
        this.fieldPaytypeInfo = Collections.unmodifiableMap(fieldPaytypeInfoTmp);
        log.info("reload PaytypeMenuCache successfully!");
    }

    private Set<String> getAllChildrenPaytype(Map<String, List<String>> parentInfo, List<String> parentCode, Set<String> childrenPaytype) {
        ArrayList<String> newParentCode = new ArrayList<String>();
        for (int i = 0; i < parentCode.size(); ++i) {
            List<String> list = parentInfo.get(parentCode.get(i));
            if (list != null) {
                newParentCode.addAll(list);
                continue;
            }
            String paytype = this.paytypeMenuInfo.get(parentCode.get(i)).getPaytype();
            if (Strings.isNullOrEmpty((String)paytype)) continue;
            childrenPaytype.add(paytype);
        }
        if (newParentCode.size() == 0) {
            return childrenPaytype;
        }
        return this.getAllChildrenPaytype(parentInfo, newParentCode, childrenPaytype);
    }

    public Map<String, LeiPaytypeMenu> getPaytypeMenuInfo() {
        return this.paytypeMenuInfo;
    }

    public Map<String, List<String>> getParentInfo() {
        return this.parentInfo;
    }

    public Map<String, Set<String>> getFieldPaytypeInfo() {
        return this.fieldPaytypeInfo;
    }

    public Map<String, List<LeiPaytypeMenu>> getChildrenInfo() {
        return this.childrenInfo;
    }
}

