/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cache;

import com.xunlei.channel.channelreport.repo.cache.IncomePaytypeMenuCache;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.channel.channelreport.vo.RepoHeaderCell;
import com.xunlei.channel.channelreport.vo.RepoHeaderRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeRepoTableCache {
    public static final Logger log = LoggerFactory.getLogger(IncomeRepoTableCache.class);
    @Autowired
    IncomePaytypeMenuCache incomePaytypeMenuCache;
    private Map<Integer, RepoHeaderRow> repoRowCache = new HashMap<Integer, RepoHeaderRow>();
    private Map<String, Map<Integer, RepoHeaderRow>> bizRowCache = new HashMap<String, Map<Integer, RepoHeaderRow>>();
    private List<RepoHeaderCell> dayReportBottomRowCells;
    private List<RepoHeaderCell> monthReportBottomRowCells;

    public void reload() {
        HashMap<Integer, RepoHeaderRow> repoRowCacheTmp = new HashMap<Integer, RepoHeaderRow>();
        Map<String, IncomePaytypeMenu> paytypeMenuInfo = this.incomePaytypeMenuCache.getPaytypeMenuInfo();
        Map<String, List<String>> parentInfo = this.incomePaytypeMenuCache.getParentInfo();
        ArrayList<String> fieldCodes = new ArrayList<String>(paytypeMenuInfo.keySet());
        Collections.sort(fieldCodes);
        for (String string : fieldCodes) {
            ArrayList<String> fieldCodeList = new ArrayList<String>();
            fieldCodeList.add(string);
            ArrayList<String> childrenCodeList = new ArrayList<String>();
            int colspan = this.getAllChildren(parentInfo, fieldCodeList, childrenCodeList).size();
            IncomePaytypeMenu paytypeMenu = paytypeMenuInfo.get(string);
            String name = paytypeMenu.getName();
            short level = paytypeMenu.getLevel();
            RepoHeaderCell cell = new RepoHeaderCell(name, string, 1, colspan, 100 * colspan, false);
            RepoHeaderRow repoHeaderRow = (RepoHeaderRow)repoRowCacheTmp.get(level);
            if (repoHeaderRow == null) {
                repoHeaderRow = new RepoHeaderRow(level, new ArrayList<RepoHeaderCell>());
            }
            repoHeaderRow.addCell(cell);
            repoRowCacheTmp.put(Integer.valueOf(level), repoHeaderRow);
        }
        for (Map.Entry entry : repoRowCacheTmp.entrySet()) {
            RepoHeaderRow row = (RepoHeaderRow)entry.getValue();
            if (row == null) continue;
            row.forbiddenChange();
        }
        this.repoRowCache = Collections.unmodifiableMap(repoRowCacheTmp);
        this.reloadDayReportBottomRow();
        this.reloadMonthReportBottomRow();
        Map<String, Map<String, List<IncomePaytypeMenu>>> bizPaytypeMap = this.incomePaytypeMenuCache.getBizPaytypeMenuMap();
        HashMap hashMap = new HashMap();
        for (String bizCode : bizPaytypeMap.keySet()) {
            HashMap<Integer, RepoHeaderRow> levelRowMap = new HashMap<Integer, RepoHeaderRow>();
            Map<String, List<IncomePaytypeMenu>> bizLevelMap = bizPaytypeMap.get(bizCode);
            for (String parentCode : bizLevelMap.keySet()) {
                int level = 1 + parentCode.length() / 4;
                RepoHeaderRow row = new RepoHeaderRow(level, new ArrayList<RepoHeaderCell>());
                for (IncomePaytypeMenu menu : bizLevelMap.get(parentCode)) {
                    row.addCell(new RepoHeaderCell(menu.getName(), menu.getFieldcode(), 1, menu.getColspan(), 100 * menu.getColspan(), false));
                }
                levelRowMap.put(level, row);
            }
            hashMap.put(bizCode, levelRowMap);
        }
        this.bizRowCache = Collections.unmodifiableMap(hashMap);
        log.info("reload RepoTableCache success!");
    }

    public void reloadDayReportBottomRow() {
        ArrayList<RepoHeaderCell> bottomCells = new ArrayList<RepoHeaderCell>();
        String[] fieldNames = new String[]{"\u4ea4\u6613\u91d1\u989d", "\u5e94\u6536\u91d1\u989d"};
        String[] fieldCodes = new String[]{"payamt", "settleamt"};
        for (int i = 0; i < fieldNames.length; ++i) {
            RepoHeaderCell cell = new RepoHeaderCell(fieldNames[i], fieldCodes[i], 1, 1, 100, false);
            bottomCells.add(cell);
        }
        this.dayReportBottomRowCells = Collections.unmodifiableList(bottomCells);
    }

    public void reloadMonthReportBottomRow() {
        ArrayList<RepoHeaderCell> bottomCells = new ArrayList<RepoHeaderCell>();
        String[] fieldNames = new String[]{"\u4ea4\u6613\u91d1\u989d", "\u5e94\u6536\u91d1\u989d", "\u5b9e\u6536\u91d1\u989d", "\u5b9e\u6536\u7387"};
        String[] fieldCodes = new String[]{"payamt", "settleamt", "realamt", "realpercent"};
        for (int i = 0; i < fieldNames.length; ++i) {
            RepoHeaderCell cell = new RepoHeaderCell(fieldNames[i], fieldCodes[i], 1, 1, 100, false);
            bottomCells.add(cell);
        }
        this.monthReportBottomRowCells = Collections.unmodifiableList(bottomCells);
    }

    private List<String> getAllChildren(Map<String, List<String>> parentInfo, List<String> parentCode, List<String> childrenCode) {
        ArrayList<String> newParentCode = new ArrayList<String>();
        for (int i = 0; i < parentCode.size(); ++i) {
            List<String> list = parentInfo.get(parentCode.get(i));
            if (list != null) {
                newParentCode.addAll(list);
                continue;
            }
            childrenCode.add(parentCode.get(i));
        }
        if (newParentCode.size() == 0) {
            return childrenCode;
        }
        return this.getAllChildren(parentInfo, newParentCode, childrenCode);
    }

    public Map<Integer, RepoHeaderRow> getRepoRowCache() {
        return this.repoRowCache;
    }

    public List<RepoHeaderCell> getDayReportBottomRowCells() {
        return this.dayReportBottomRowCells;
    }

    public List<RepoHeaderCell> getMonthReportBottomRowCells() {
        return this.monthReportBottomRowCells;
    }

    public static Logger getLog() {
        return log;
    }

    public Map<String, Map<Integer, RepoHeaderRow>> getBizRowCache() {
        return this.bizRowCache;
    }
}

