/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cache;

import com.xunlei.channel.channelreport.dao.IncomePaytypeMenuDao;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.util.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomePaytypeMenuCache {
    public static final Logger log = LoggerFactory.getLogger(IncomePaytypeMenuCache.class);
    @Autowired
    IncomePaytypeMenuDao incomePaytypeMenuDao;
    private Map<String, IncomePaytypeMenu> paytypeMenuInfo = new HashMap<String, IncomePaytypeMenu>();
    private Map<String, List<String>> parentInfo = new HashMap<String, List<String>>();
    private Map<String, Set<String>> fieldPaytypeInfo = new HashMap<String, Set<String>>();
    private Map<String, List<IncomePaytypeMenu>> childrenInfo = new HashMap<String, List<IncomePaytypeMenu>>();
    private Map<String, Map<String, List<IncomePaytypeMenu>>> bizPaytypeMenuMap = new HashMap<String, Map<String, List<IncomePaytypeMenu>>>();

    public void reload() {
        HashMap<String, IncomePaytypeMenu> paytypeMenuInfoTmp = new HashMap<String, IncomePaytypeMenu>();
        HashMap<String, List<String>> parentInfoTmp = new HashMap<String, List<String>>();
        HashMap<String, Set<String>> fieldPaytypeInfoTmp = new HashMap<String, Set<String>>();
        HashMap<String, ArrayList<IncomePaytypeMenu>> childrenInfoTmp = new HashMap<String, ArrayList<IncomePaytypeMenu>>();
        List<HashMap<String, Object>> paytypeMenuMapList = this.incomePaytypeMenuDao.getPaytypeMenuMapList("filedcode");
        for (HashMap<String, Object> hashMap : paytypeMenuMapList) {
            String fieldCode = hashMap.get("fieldcode").toString();
            short level = Short.valueOf(hashMap.get("level").toString());
            String parentCode = hashMap.get("parentcode").toString();
            String paytype = hashMap.get("paytype").toString();
            String name = hashMap.get("name").toString();
            int seqId = Integer.valueOf(hashMap.get("seqid").toString());
            IncomePaytypeMenu paytypeMenu = new IncomePaytypeMenu(seqId, name, fieldCode, parentCode, level, paytype);
            paytypeMenuInfoTmp.put(paytypeMenu.getFieldcode(), paytypeMenu);
            if (!StringTools.isEmpty((CharSequence)parentCode)) {
                ArrayList<String> childrenList = (ArrayList<String>)parentInfoTmp.get(parentCode);
                if (childrenList == null) {
                    childrenList = new ArrayList<String>();
                }
                childrenList.add(fieldCode);
                parentInfoTmp.put(parentCode, childrenList);
                ArrayList<IncomePaytypeMenu> children = (ArrayList<IncomePaytypeMenu>)childrenInfoTmp.get(parentCode);
                if (null == children) {
                    children = new ArrayList<IncomePaytypeMenu>();
                }
                children.add(paytypeMenu);
                childrenInfoTmp.put(parentCode, children);
                continue;
            }
            ArrayList<IncomePaytypeMenu> children = (ArrayList<IncomePaytypeMenu>)childrenInfoTmp.get("");
            if (null == children) {
                children = new ArrayList<IncomePaytypeMenu>();
            }
            children.add(paytypeMenu);
            childrenInfoTmp.put("", children);
        }
        this.childrenInfo = Collections.unmodifiableMap(childrenInfoTmp);
        this.paytypeMenuInfo = Collections.unmodifiableMap(paytypeMenuInfoTmp);
        for (String string : this.paytypeMenuInfo.keySet()) {
            ArrayList<String> parentCode = new ArrayList<String>();
            parentCode.add(string);
            Set<String> paytypes = this.getAllChildrenPaytype(parentInfoTmp, parentCode, new HashSet<String>());
            log.debug("fieldCode:{},paytypes size:{}", (Object)string, (Object)paytypes.size());
            fieldPaytypeInfoTmp.put(string, Collections.unmodifiableSet(paytypes));
        }
        for (Map.Entry entry : parentInfoTmp.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            parentInfoTmp.put(key, Collections.unmodifiableList(value));
        }
        this.parentInfo = Collections.unmodifiableMap(parentInfoTmp);
        this.fieldPaytypeInfo = Collections.unmodifiableMap(fieldPaytypeInfoTmp);
        List<HashMap<String, Object>> bizPaytypeMapList = this.incomePaytypeMenuDao.getBizPaytypeMenuMapList();
        HashMap hashMap = new HashMap();
        HashSet<String> bizCodeSet = new HashSet<String>();
        for (HashMap<String, Object> bpMap : bizPaytypeMapList) {
            String bizCode = bpMap.get("bizcode").toString();
            String paytypeCode = bpMap.get("paytypecode").toString();
            bizCodeSet.add(bizCode);
            if (!hashMap.containsKey(bizCode)) {
                hashMap.put(bizCode, new HashMap());
            }
            int level = paytypeCode.length() / 4;
            Map paytypeMap = (Map)hashMap.get(bizCode);
            for (int i = 1; i <= level; ++i) {
                String code = paytypeCode.substring(0, 4 * i);
                String parentCode = code.substring(0, 4 * i - 4);
                if (!paytypeMap.containsKey(parentCode)) {
                    paytypeMap.put(parentCode, new HashSet());
                }
                ((Set)paytypeMap.get(parentCode)).add(this.paytypeMenuInfo.get(code));
            }
        }
        for (String bizCode : bizCodeSet) {
            int level;
            for (int i = level = bizCode.length() / 4; i >= 1; --i) {
                String code = bizCode.substring(0, 4 * i);
                String parentCode = code.substring(0, 4 * i - 4);
                Map bizMap = (Map)hashMap.get(code);
                HashMap parentMap = (HashMap)hashMap.get(parentCode);
                if (null == parentMap) {
                    parentMap = new HashMap();
                    hashMap.put(parentCode, parentMap);
                }
                for (String key : bizMap.keySet()) {
                    if (parentMap.containsKey(key)) {
                        ((Set)parentMap.get(key)).addAll((Collection)bizMap.get(key));
                        continue;
                    }
                    HashSet set = new HashSet();
                    set.addAll((Collection)bizMap.get(key));
                    parentMap.put(key, set);
                }
            }
        }
        HashMap bizPaytypeMenuMapNew = new HashMap();
        for (String bizCode : hashMap.keySet()) {
            Map paytypeSetMap = (Map)hashMap.get(bizCode);
            HashMap newMap = new HashMap();
            for (String parentCode : paytypeSetMap.keySet()) {
                ArrayList<IncomePaytypeMenu> menuList = new ArrayList<IncomePaytypeMenu>();
                for (IncomePaytypeMenu menu : (Set)paytypeSetMap.get(parentCode)) {
                    IncomePaytypeMenu newMenu = menu.clone();
                    newMenu.setColspan(this.generateColspan(paytypeSetMap, menu.getFieldcode()));
                    menuList.add(newMenu);
                }
                Collections.sort(menuList);
                newMap.put(parentCode, menuList);
            }
            bizPaytypeMenuMapNew.put(bizCode, newMap);
        }
        this.bizPaytypeMenuMap = Collections.unmodifiableMap(bizPaytypeMenuMapNew);
        log.info("reload PaytypeMenuCache successfully!");
    }

    private int generateColspan(Map<String, Set<IncomePaytypeMenu>> paytypeSetMap, String code) {
        if (paytypeSetMap.containsKey(code)) {
            int sum = 0;
            for (IncomePaytypeMenu pm : paytypeSetMap.get(code)) {
                sum += this.generateColspan(paytypeSetMap, pm.getFieldcode());
            }
            return sum;
        }
        return 1;
    }

    private Set<String> getAllChildrenPaytype(Map<String, List<String>> parentInfo, List<String> parentCode, Set<String> childrenPaytype) {
        ArrayList<String> newParentCode = new ArrayList<String>();
        for (int i = 0; i < parentCode.size(); ++i) {
            List<String> list = parentInfo.get(parentCode.get(i));
            if (list != null) {
                newParentCode.addAll(list);
                continue;
            }
            String paytype = this.paytypeMenuInfo.get(parentCode.get(i)).getPaytype();
            if (!StringTools.isNotEmpty((CharSequence)paytype)) continue;
            childrenPaytype.add(paytype);
        }
        if (newParentCode.size() == 0) {
            return childrenPaytype;
        }
        return this.getAllChildrenPaytype(parentInfo, newParentCode, childrenPaytype);
    }

    public Map<String, IncomePaytypeMenu> getPaytypeMenuInfo() {
        return this.paytypeMenuInfo;
    }

    public Map<String, List<String>> getParentInfo() {
        return this.parentInfo;
    }

    public Map<String, Set<String>> getFieldPaytypeInfo() {
        return this.fieldPaytypeInfo;
    }

    public Map<String, List<IncomePaytypeMenu>> getChildrenInfo() {
        return this.childrenInfo;
    }

    public static Logger getLog() {
        return log;
    }

    public Map<String, Map<String, List<IncomePaytypeMenu>>> getBizPaytypeMenuMap() {
        return this.bizPaytypeMenuMap;
    }
}

