/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.cache;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.IncomeBizMenuDao;
import com.xunlei.channel.channelreport.vo.IncomeBizMenu;
import com.xunlei.util.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeBizMenuCache {
    public static final Logger log = LoggerFactory.getLogger(IncomeBizMenuCache.class);
    @Autowired
    IncomeBizMenuDao incomeBizMenuDao;
    private Map<String, IncomeBizMenu> bizMenuInfo = new HashMap<String, IncomeBizMenu>();
    private Map<String, List<String>> parentInfo = new HashMap<String, List<String>>();
    private Map<String, Set<String>> fieldBizInfo = new HashMap<String, Set<String>>();
    private Map<String, List<IncomeBizMenu>> childrenInfo = new HashMap<String, List<IncomeBizMenu>>();

    public void reload() {
        HashMap<String, IncomeBizMenu> bizMenuInfoTmp = new HashMap<String, IncomeBizMenu>();
        HashMap<String, List<String>> parentInfoTmp = new HashMap<String, List<String>>();
        HashMap<String, Set<String>> fieldBizInfoTmp = new HashMap<String, Set<String>>();
        HashMap<String, ArrayList<IncomeBizMenu>> childrenInfoTmp = new HashMap<String, ArrayList<IncomeBizMenu>>();
        List<HashMap<String, Object>> bizMenuMapList = this.incomeBizMenuDao.getBizMenuMapList("filedcode");
        for (HashMap<String, Object> hashMap : bizMenuMapList) {
            String fieldCode = hashMap.get("fieldcode").toString();
            short level = Short.valueOf(hashMap.get("level").toString());
            String parentCode = hashMap.get("parentcode").toString();
            String bizno = hashMap.get("bizno").toString();
            String name = hashMap.get("name").toString();
            int seqId = Integer.valueOf(hashMap.get("seqid").toString());
            IncomeBizMenu bizMenu = new IncomeBizMenu(seqId, name, fieldCode, parentCode, level, bizno);
            bizMenuInfoTmp.put(bizMenu.getFieldcode(), bizMenu);
            if (!StringTools.isEmpty((CharSequence)parentCode)) {
                ArrayList<String> childrenList = (ArrayList<String>)parentInfoTmp.get(parentCode);
                if (childrenList == null) {
                    childrenList = new ArrayList<String>();
                }
                childrenList.add(fieldCode);
                parentInfoTmp.put(parentCode, childrenList);
                ArrayList<IncomeBizMenu> menuChildrenList = (ArrayList<IncomeBizMenu>)childrenInfoTmp.get(parentCode);
                if (null == menuChildrenList) {
                    menuChildrenList = new ArrayList<IncomeBizMenu>();
                }
                menuChildrenList.add(bizMenu);
                childrenInfoTmp.put(parentCode, menuChildrenList);
                continue;
            }
            ArrayList<IncomeBizMenu> menuChildrenList = (ArrayList<IncomeBizMenu>)childrenInfoTmp.get("");
            if (null == menuChildrenList) {
                menuChildrenList = new ArrayList<IncomeBizMenu>();
            }
            menuChildrenList.add(bizMenu);
            childrenInfoTmp.put("", menuChildrenList);
        }
        this.bizMenuInfo = Collections.unmodifiableMap(bizMenuInfoTmp);
        for (String string : this.bizMenuInfo.keySet()) {
            ArrayList<String> parentCode = new ArrayList<String>();
            parentCode.add(string);
            Set<String> paytypes = this.getAllChildrenPaytype(parentInfoTmp, parentCode, new HashSet<String>());
            fieldBizInfoTmp.put(string, Collections.unmodifiableSet(paytypes));
        }
        for (Map.Entry entry : parentInfoTmp.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            parentInfoTmp.put(key, Collections.unmodifiableList(value));
        }
        this.parentInfo = Collections.unmodifiableMap(parentInfoTmp);
        this.fieldBizInfo = Collections.unmodifiableMap(fieldBizInfoTmp);
        this.childrenInfo = Collections.unmodifiableMap(childrenInfoTmp);
        log.info("reload BizMenuCache successfully!");
    }

    private Set<String> getAllChildrenPaytype(Map<String, List<String>> parentInfo, List<String> parentCode, Set<String> childrenBizno) {
        ArrayList<String> newParentCode = new ArrayList<String>();
        for (int i = 0; i < parentCode.size(); ++i) {
            List<String> list = parentInfo.get(parentCode.get(i));
            if (list != null) {
                newParentCode.addAll(list);
                continue;
            }
            String bizno = this.bizMenuInfo.get(parentCode.get(i)).getBizno();
            if (!StringTools.isNotEmpty((CharSequence)bizno)) continue;
            childrenBizno.add(bizno);
        }
        if (newParentCode.size() == 0) {
            return childrenBizno;
        }
        return this.getAllChildrenPaytype(parentInfo, newParentCode, childrenBizno);
    }

    public IncomeBizMenu getRootIncomeBizMenu(String fieldCode) {
        IncomeBizMenu bizMenu = this.bizMenuInfo.get(fieldCode);
        if (bizMenu == null) {
            return null;
        }
        String parentCode = bizMenu.getParentcode();
        if (Strings.isNullOrEmpty((String)parentCode)) {
            return bizMenu;
        }
        return this.getRootIncomeBizMenu(parentCode);
    }

    public Map<String, List<String>> getParentInfo() {
        return this.parentInfo;
    }

    public Map<String, IncomeBizMenu> getBizMenuInfo() {
        return this.bizMenuInfo;
    }

    public Map<String, Set<String>> getFieldBizInfo() {
        return this.fieldBizInfo;
    }

    public Map<String, List<IncomeBizMenu>> getChildrenInfo() {
        return this.childrenInfo;
    }
}

