/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.bo;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.LeiMonthReportDao;
import com.xunlei.channel.channelreport.repo.cache.LeiPaytypeMenuCache;
import com.xunlei.channel.channelreport.repo.cache.LeiRepoTableCache;
import com.xunlei.channel.channelreport.statistics.cache.LeiPaytypeinfoCache;
import com.xunlei.channel.channelreport.util.Arith;
import com.xunlei.channel.channelreport.vo.RepoHeaderCell;
import com.xunlei.channel.channelreport.vo.RepoHeaderRow;
import com.xunlei.json.JSONUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthRepoDataBo {
    @Autowired
    private LeiMonthReportDao leiMonthReportDao;
    @Autowired
    private LeiPaytypeMenuCache leiPaytypeMenuCache;
    @Autowired
    private LeiRepoTableCache leiRepoTableCache;
    @Autowired
    private LeiPaytypeinfoCache leiPaytypeinfoCache;
    private DecimalFormat format = new DecimalFormat("0.00%");
    private String paytypesPayAmtKey = "payamtpaytypestotal";
    private String paytypesSettleAmtKey = "settleamtpaytypestotal";
    private String paytypesRealAmtKey = "realamtpaytypestotal";
    private String paytypesPercentKey = "realpercentpaytypestotal";

    public String getMonthRepoData(int bottomLevel, String balanceFromMonth, String balanceToMonth, String paytypeCode, int pageNo, int pageSize) throws ParseException {
        ArrayList dataList = new ArrayList();
        DecimalFormat moneyFormatter = new DecimalFormat("##,##0.00");
        RepoHeaderRow repoHeaderRow = this.leiRepoTableCache.getRepoRowCache().get(bottomLevel);
        if (repoHeaderRow == null) {
            return null;
        }
        List<RepoHeaderCell> cells = repoHeaderRow.getCells();
        Map<String, Set<String>> fieldPaytypeInfo = this.leiPaytypeMenuCache.getFieldPaytypeInfo();
        Set<String> paytypes = fieldPaytypeInfo.get(paytypeCode);
        ArrayList<String> validFieldCodes = null;
        if (!Strings.isNullOrEmpty((String)paytypeCode)) {
            int choosenLevel = this.leiPaytypeMenuCache.getPaytypeMenuInfo().get(paytypeCode).getLevel();
            ArrayList<String> childrenFieldCodes = new ArrayList<String>();
            childrenFieldCodes.add(paytypeCode);
            ArrayList<String> childrenFieldCodesTmp = new ArrayList<String>();
            childrenFieldCodesTmp.add(paytypeCode);
            for (int i = choosenLevel; i < bottomLevel; ++i) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (int j = 0; j < childrenFieldCodesTmp.size(); ++j) {
                    String code = (String)childrenFieldCodesTmp.get(j);
                    List<String> codes = this.leiPaytypeMenuCache.getParentInfo().get(code);
                    tmp.addAll(codes);
                    childrenFieldCodes.addAll(codes);
                }
                childrenFieldCodesTmp = tmp;
            }
            validFieldCodes = childrenFieldCodes;
        }
        Map<String, HashMap<String, Double>> dayReportDataList = this.leiMonthReportDao.queryMonthReportData(balanceFromMonth, balanceToMonth, paytypes);
        Calendar fromDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(new SimpleDateFormat("yyyy-MM").parse(balanceFromMonth));
        Calendar toDateCalendar = Calendar.getInstance();
        toDateCalendar.setTime(new SimpleDateFormat("yyyy-MM").parse(balanceToMonth));
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("balancemonth", "\u5408\u8ba1");
        while (!toDateCalendar.before(fromDateCalendar)) {
            double monthTotalPayAmt = 0.0;
            double monthTotalSettleAmt = 0.0;
            double monthTotalRealAmt = 0.0;
            HashMap<String, String> dataMap = new HashMap<String, String>();
            boolean validBalancedate = false;
            String nowDate = new SimpleDateFormat("yyyy-MM").format(toDateCalendar.getTime());
            dataMap.put("balancemonth", nowDate);
            for (RepoHeaderCell cell : cells) {
                String fieldCode = cell.getField();
                boolean paytypeCodeIsNull = Strings.isNullOrEmpty((String)paytypeCode);
                if (!paytypeCodeIsNull && !validFieldCodes.contains(fieldCode)) continue;
                double totalPayAmt = 0.0;
                double totalSettleAmt = 0.0;
                double totalRealAmt = 0.0;
                Set<String> cellPaytypes = fieldPaytypeInfo.get(fieldCode);
                for (String paytype : cellPaytypes) {
                    String key = nowDate + paytype;
                    Map map = dayReportDataList.get(key);
                    if (map == null) continue;
                    validBalancedate = true;
                    totalPayAmt = Arith.add(totalPayAmt, (Double)map.get("payamt"));
                    totalSettleAmt = Arith.add(totalSettleAmt, (Double)map.get("settleamt"));
                    totalRealAmt = Arith.add(totalRealAmt, (Double)map.get("realamt"));
                    if (!"1".equals(this.leiPaytypeinfoCache.getPaytypeinfo(paytype).get("inrealrate"))) continue;
                    monthTotalPayAmt = Arith.add(monthTotalPayAmt, (Double)map.get("payamt"));
                    monthTotalSettleAmt = Arith.add(monthTotalSettleAmt, (Double)map.get("settleamt"));
                    monthTotalRealAmt = Arith.add(monthTotalRealAmt, (Double)map.get("realamt"));
                }
                String payAmtKey = "payamt" + fieldCode;
                String settleAmtKey = "settleamt" + fieldCode;
                String realAmtKey = "realamt" + fieldCode;
                String percentKey = "realpercent" + fieldCode;
                dataMap.put(payAmtKey, moneyFormatter.format(totalPayAmt));
                dataMap.put(settleAmtKey, moneyFormatter.format(totalSettleAmt));
                dataMap.put(realAmtKey, moneyFormatter.format(totalRealAmt));
                dataMap.put(percentKey, totalPayAmt == 0.0 ? "0%" : Arith.div(totalRealAmt, totalPayAmt, 5, this.format));
                if (totalMap.get(payAmtKey) == null) {
                    totalMap.put(payAmtKey, totalPayAmt);
                } else {
                    totalMap.put(payAmtKey, Arith.add((Double)totalMap.get(payAmtKey), totalPayAmt));
                }
                if (totalMap.get(settleAmtKey) == null) {
                    totalMap.put(settleAmtKey, totalSettleAmt);
                } else {
                    totalMap.put(settleAmtKey, Arith.add((Double)totalMap.get(settleAmtKey), totalSettleAmt));
                }
                if (totalMap.get(realAmtKey) == null) {
                    totalMap.put(realAmtKey, totalRealAmt);
                    continue;
                }
                totalMap.put(realAmtKey, Arith.add((Double)totalMap.get(realAmtKey), totalRealAmt));
            }
            dataMap.put(this.paytypesPayAmtKey, moneyFormatter.format(monthTotalPayAmt));
            dataMap.put(this.paytypesSettleAmtKey, moneyFormatter.format(monthTotalSettleAmt));
            dataMap.put(this.paytypesRealAmtKey, moneyFormatter.format(monthTotalRealAmt));
            dataMap.put(this.paytypesPercentKey, monthTotalPayAmt == 0.0 ? "0%" : Arith.div(monthTotalRealAmt, monthTotalPayAmt, 5, this.format));
            if (totalMap.get(this.paytypesPayAmtKey) == null) {
                totalMap.put(this.paytypesPayAmtKey, monthTotalPayAmt);
            } else {
                totalMap.put(this.paytypesPayAmtKey, Arith.add((Double)totalMap.get(this.paytypesPayAmtKey), monthTotalPayAmt));
            }
            if (totalMap.get(this.paytypesSettleAmtKey) == null) {
                totalMap.put(this.paytypesSettleAmtKey, monthTotalSettleAmt);
            } else {
                totalMap.put(this.paytypesSettleAmtKey, Arith.add((Double)totalMap.get(this.paytypesSettleAmtKey), monthTotalSettleAmt));
            }
            if (totalMap.get(this.paytypesRealAmtKey) == null) {
                totalMap.put(this.paytypesRealAmtKey, monthTotalRealAmt);
            } else {
                totalMap.put(this.paytypesRealAmtKey, Arith.add((Double)totalMap.get(this.paytypesRealAmtKey), monthTotalRealAmt));
            }
            if (validBalancedate) {
                dataList.add(dataMap);
            }
            toDateCalendar.add(2, -1);
        }
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = pageNo * pageSize;
        int dataListSize = dataList.size();
        if (fromIndex > dataListSize) {
            dataList = new ArrayList();
        } else if (toIndex > dataListSize) {
            toIndex = dataListSize;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> footerList = new ArrayList<HashMap<String, Object>>();
        footerList.add(totalMap);
        for (RepoHeaderCell cell : cells) {
            String fieldCode = cell.getField();
            String payAmtKey = "payamt" + fieldCode;
            String realAmtKey = "realamt" + fieldCode;
            Object payAmt = totalMap.get(payAmtKey);
            Object realAmt = totalMap.get(realAmtKey);
            String percentKey = "realpercent" + fieldCode;
            if (payAmt != null && realAmt != null) {
                totalMap.put(percentKey, (Double)payAmt == 0.0 ? "0%" : Arith.div((Double)realAmt, (Double)payAmt, 5, this.format));
                continue;
            }
            totalMap.put(percentKey, "0%");
        }
        Object paytypesPayAmt = totalMap.get(this.paytypesPayAmtKey);
        Object paytypesRealAmt = totalMap.get(this.paytypesRealAmtKey);
        if (paytypesPayAmt != null && paytypesRealAmt != null) {
            totalMap.put(this.paytypesPercentKey, (Double)paytypesPayAmt == 0.0 ? "0%" : Arith.div((Double)paytypesRealAmt, (Double)paytypesPayAmt, 5, this.format));
        }
        for (String key : totalMap.keySet()) {
            if (!(totalMap.get(key) instanceof Double)) continue;
            totalMap.put(key, moneyFormatter.format(totalMap.get(key)));
        }
        dataMap.put("total", dataList.size());
        dataMap.put("rows", dataList.subList(fromIndex, toIndex));
        dataMap.put("footer", footerList);
        return JSONUtil.fromObject(dataMap);
    }
}

