/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.bo;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.cache.LeiPaytypeMenuCache;
import com.xunlei.channel.channelreport.repo.cache.LeiRepoTableCache;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.channel.channelreport.vo.LeiPaytypeMenu;
import com.xunlei.channel.channelreport.vo.RepoHeaderCell;
import com.xunlei.channel.channelreport.vo.RepoHeaderRow;
import com.xunlei.json.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeiDayRepoTableBo {
    @Autowired
    LeiRepoTableCache leiRepoTableCache;
    @Autowired
    LeiPaytypeMenuCache leiPaytypeMenuCache;

    public String createTableHeader(int fromLevel, int toLevel, String fromDate, String toDate, String paytypeCode) {
        boolean paytypeCodeIsNull;
        ArrayList<RepoHeaderCell> cells;
        Map<Integer, RepoHeaderRow> repoRowMap = this.leiRepoTableCache.getRepoRowCache();
        ArrayList<RepoHeaderRow> validRepoHeaderRowList = new ArrayList<RepoHeaderRow>();
        List<RepoHeaderCell> bottomRowCells = this.leiRepoTableCache.getDayReportBottomRowCells();
        int bottomLevel = fromLevel;
        int topLevel = fromLevel;
        boolean first = true;
        for (int i = fromLevel; i <= toLevel; ++i) {
            RepoHeaderRow repoHeaderRow = repoRowMap.get(i);
            if (repoHeaderRow == null) continue;
            bottomLevel = i;
            if (first) {
                topLevel = i;
                first = false;
            }
            validRepoHeaderRowList.add(repoHeaderRow);
        }
        ArrayList<RepoHeaderRow> finalRepoHeaderRowList = new ArrayList<RepoHeaderRow>();
        int rowsnum = validRepoHeaderRowList.size() + 1;
        ArrayList<String> validFieldCodes = null;
        if (!Strings.isNullOrEmpty((String)paytypeCode)) {
            int choosenLevel = this.leiPaytypeMenuCache.getPaytypeMenuInfo().get(paytypeCode).getLevel();
            ArrayList<String> parentFieldCodes = new ArrayList<String>();
            String parentCode = paytypeCode;
            for (int i = choosenLevel; i > topLevel; --i) {
                String code = this.leiPaytypeMenuCache.getPaytypeMenuInfo().get(parentCode).getParentcode();
                parentFieldCodes.add(code);
                parentCode = code;
            }
            ArrayList<String> childrenFieldCodes = new ArrayList<String>();
            childrenFieldCodes.add(paytypeCode);
            ArrayList<String> childrenFieldCodesTmp = new ArrayList<String>();
            childrenFieldCodesTmp.add(paytypeCode);
            for (int i = choosenLevel; i < bottomLevel; ++i) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (int j = 0; j < childrenFieldCodesTmp.size(); ++j) {
                    String code = (String)childrenFieldCodesTmp.get(j);
                    List<String> codes = this.leiPaytypeMenuCache.getParentInfo().get(code);
                    tmp.addAll(codes);
                    childrenFieldCodes.addAll(codes);
                }
                childrenFieldCodesTmp = tmp;
            }
            parentFieldCodes.addAll(childrenFieldCodes);
            validFieldCodes = parentFieldCodes;
        }
        for (int i = 0; i < validRepoHeaderRowList.size(); ++i) {
            List<RepoHeaderCell> cellListCache = ((RepoHeaderRow)validRepoHeaderRowList.get(i)).getCells();
            cells = new ArrayList<RepoHeaderCell>();
            if (i == 0) {
                RepoHeaderCell timeCell = new RepoHeaderCell("\u65e5\u671f", "balancedate", rowsnum, 1, 100, true);
                cells.add(timeCell);
            }
            for (int j = 0; j < cellListCache.size(); ++j) {
                RepoHeaderCell cellCache = cellListCache.get(j);
                paytypeCodeIsNull = Strings.isNullOrEmpty((String)paytypeCode);
                if (!paytypeCodeIsNull && (paytypeCodeIsNull || !validFieldCodes.contains(cellCache.getField()))) continue;
                RepoHeaderCell cell = new RepoHeaderCell(cellCache.getTitle(), "", cellCache.getRowspan(), cellCache.getColspan() * bottomRowCells.size(), cellCache.getColspan() * bottomRowCells.size() * 100, cellCache.isFrozen());
                cells.add(cell);
            }
            if (i == 0) {
                RepoHeaderCell paytypesTotalCell = new RepoHeaderCell("\u5408\u8ba1", "", rowsnum - 1, bottomRowCells.size(), 100, false);
                cells.add(paytypesTotalCell);
            }
            RepoHeaderRow repoHeaderRow = new RepoHeaderRow(i, cells);
            finalRepoHeaderRowList.add(repoHeaderRow);
        }
        RepoHeaderRow lastLevelRow = (RepoHeaderRow)validRepoHeaderRowList.get(validRepoHeaderRowList.size() - 1);
        List<RepoHeaderCell> lastLevelCells = lastLevelRow.getCells();
        cells = new ArrayList();
        for (int i = 0; i < lastLevelCells.size(); ++i) {
            String fieldCode = lastLevelCells.get(i).getField();
            paytypeCodeIsNull = Strings.isNullOrEmpty((String)paytypeCode);
            if (!paytypeCodeIsNull && (paytypeCodeIsNull || !validFieldCodes.contains(fieldCode))) continue;
            for (int j = 0; j < bottomRowCells.size(); ++j) {
                RepoHeaderCell bottomCell = bottomRowCells.get(j);
                RepoHeaderCell cell = new RepoHeaderCell(bottomCell.getTitle(), bottomCell.getField() + fieldCode, bottomCell.getRowspan(), bottomCell.getColspan(), bottomCell.getWidth(), bottomCell.isFrozen());
                cells.add(cell);
            }
        }
        for (int j = 0; j < bottomRowCells.size(); ++j) {
            RepoHeaderCell bottomCell = bottomRowCells.get(j);
            RepoHeaderCell cell = new RepoHeaderCell(bottomCell.getTitle(), bottomCell.getField() + "paytypestotal", bottomCell.getRowspan(), bottomCell.getColspan(), bottomCell.getWidth(), bottomCell.isFrozen());
            cells.add(cell);
        }
        RepoHeaderRow bottomRow = new RepoHeaderRow(validRepoHeaderRowList.size(), cells);
        finalRepoHeaderRowList.add(bottomRow);
        String dataUrl = ReportRepoUtil.createLeiDayRepoDataUrl(bottomLevel, fromDate, toDate, paytypeCode);
        String paytypeName = "\u5168\u90e8\u6e20\u9053";
        LeiPaytypeMenu paytypeMenu = this.leiPaytypeMenuCache.getPaytypeMenuInfo().get(paytypeCode);
        if (paytypeMenu != null) {
            paytypeName = paytypeMenu.getName();
        }
        String excelTitle = "\u96f7\u70b9\u6d41\u6c34_" + paytypeName + "_\u65e5\u6570\u636e";
        ArrayList dataArray = new ArrayList();
        for (int i = 0; i < finalRepoHeaderRowList.size(); ++i) {
            HashMap<String, List<RepoHeaderCell>> dataMap = new HashMap<String, List<RepoHeaderCell>>();
            dataMap.put("row", ((RepoHeaderRow)finalRepoHeaderRowList.get(i)).getCells());
            dataArray.add(dataMap);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("dataurl", dataUrl);
        dataMap.put("title", excelTitle);
        dataMap.put("tableheader", dataArray);
        return JSONUtil.fromObject(dataMap);
    }
}

