/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.bo;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.repo.cache.IncomeBizMenuCache;
import com.xunlei.channel.channelreport.repo.cache.IncomePaytypeMenuCache;
import com.xunlei.channel.channelreport.repo.cache.IncomeRepoTableCache;
import com.xunlei.channel.channelreport.util.ReportRepoUtil;
import com.xunlei.channel.channelreport.vo.IncomeBizMenu;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.channel.channelreport.vo.RepoHeaderCell;
import com.xunlei.channel.channelreport.vo.RepoHeaderRow;
import com.xunlei.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthRepoTableBo {
    @Autowired
    IncomeRepoTableCache incomeRepoTableCache;
    @Autowired
    IncomePaytypeMenuCache incomePaytypeMenuCache;
    @Autowired
    private IncomeBizMenuCache incomeBizMenuCache;

    public String createBizTableHeader(int fromLevel, int toLevel, String fromMonth, String toMonth, String bizCode, String paytypeCode) {
        int i;
        RepoHeaderRow row;
        LinkedList<RepoHeaderRow> validRepoHeaderRowList = new LinkedList<RepoHeaderRow>();
        Map<String, List<IncomePaytypeMenu>> childrenMap = this.incomePaytypeMenuCache.getBizPaytypeMenuMap().get(bizCode);
        if (!Strings.isNullOrEmpty((String)paytypeCode)) {
            IncomePaytypeMenu chosenMenu = this.incomePaytypeMenuCache.getPaytypeMenuInfo().get(paytypeCode);
            int chosenColspan = 0;
            if (childrenMap.containsKey(paytypeCode)) {
                for (IncomePaytypeMenu child : childrenMap.get(paytypeCode)) {
                    chosenColspan += child.getColspan().intValue();
                }
            } else {
                chosenColspan = 1;
            }
            row = new RepoHeaderRow(1, new ArrayList<RepoHeaderCell>());
            row.addCell(new RepoHeaderCell(chosenMenu, chosenColspan));
            validRepoHeaderRowList.add(row);
            int chosenLevel = Strings.isNullOrEmpty((String)paytypeCode) ? 1 : paytypeCode.length() / 4;
            if (fromLevel < chosenLevel) {
                Object parentCode = chosenMenu.getParentcode();
                for (i = chosenLevel - 1; i >= fromLevel; --i) {
                    if (Strings.isNullOrEmpty((String)parentCode)) continue;
                    IncomePaytypeMenu parent = this.incomePaytypeMenuCache.getPaytypeMenuInfo().get(parentCode);
                    if (null != parent) {
                        row = new RepoHeaderRow(1, new ArrayList<RepoHeaderCell>());
                        row.addCell(new RepoHeaderCell(parent, chosenColspan));
                        validRepoHeaderRowList.add(0, row);
                    }
                    parentCode = parent.getParentcode();
                }
            }
        }
        int bottomLevel = 2;
        if (childrenMap.containsKey(paytypeCode)) {
            List<IncomePaytypeMenu> childList = childrenMap.get(paytypeCode);
            while (childList.size() > 0) {
                ArrayList<IncomePaytypeMenu> nextChildList = new ArrayList<IncomePaytypeMenu>();
                row = new RepoHeaderRow(1, new ArrayList<RepoHeaderCell>());
                for (IncomePaytypeMenu child : childList) {
                    bottomLevel = child.getLevel();
                    row.addCell(new RepoHeaderCell(child));
                    if (!childrenMap.containsKey(child.getFieldcode())) continue;
                    nextChildList.addAll((Collection<IncomePaytypeMenu>)childrenMap.get(child.getFieldcode()));
                }
                validRepoHeaderRowList.add(row);
                childList = nextChildList;
            }
        }
        int rowsNum = validRepoHeaderRowList.size() + 1;
        List<RepoHeaderCell> bottomRowCells = this.incomeRepoTableCache.getMonthReportBottomRowCells();
        ArrayList<RepoHeaderRow> finalHeaderRowList = new ArrayList<RepoHeaderRow>();
        for (i = 0; i < validRepoHeaderRowList.size(); ++i) {
            RepoHeaderRow theRow = (RepoHeaderRow)validRepoHeaderRowList.get(i);
            RepoHeaderRow finalRow = new RepoHeaderRow(i, new ArrayList<RepoHeaderCell>());
            if (i == 0) {
                RepoHeaderCell timeCell = new RepoHeaderCell("\u6708\u4efd", "balancemonth", rowsNum, 1, 100, true);
                finalRow.addCell(timeCell);
            }
            for (RepoHeaderCell theCell : theRow.getCells()) {
                RepoHeaderCell cell = new RepoHeaderCell(theCell.getTitle(), "", theCell.getRowspan(), theCell.getColspan() * bottomRowCells.size(), theCell.getColspan() * bottomRowCells.size() * 100, theCell.isFrozen());
                finalRow.addCell(cell);
            }
            if (i == 0) {
                RepoHeaderCell paytypesTotalCell = new RepoHeaderCell("\u5408\u8ba1", "", rowsNum - 1, bottomRowCells.size(), 100, false);
                finalRow.addCell(paytypesTotalCell);
            }
            finalHeaderRowList.add(finalRow);
        }
        RepoHeaderRow lastLevelRow = (RepoHeaderRow)validRepoHeaderRowList.get(finalHeaderRowList.size() - 1);
        List<RepoHeaderCell> lastLevelCells = lastLevelRow.getCells();
        ArrayList<RepoHeaderCell> cells = new ArrayList<RepoHeaderCell>();
        for (int i2 = 0; i2 < lastLevelCells.size(); ++i2) {
            String fieldCode = lastLevelCells.get(i2).getField();
            for (int j = 0; j < bottomRowCells.size(); ++j) {
                RepoHeaderCell bottomCell = bottomRowCells.get(j);
                RepoHeaderCell cell = new RepoHeaderCell(bottomCell.getTitle(), bottomCell.getField() + fieldCode, bottomCell.getRowspan(), bottomCell.getColspan(), bottomCell.getWidth(), bottomCell.isFrozen());
                cells.add(cell);
            }
        }
        for (int j = 0; j < bottomRowCells.size(); ++j) {
            RepoHeaderCell bottomCell = bottomRowCells.get(j);
            RepoHeaderCell cell = new RepoHeaderCell(bottomCell.getTitle(), bottomCell.getField() + "paytypestotal", bottomCell.getRowspan(), bottomCell.getColspan(), bottomCell.getWidth(), bottomCell.isFrozen());
            cells.add(cell);
        }
        RepoHeaderRow bottomRow = new RepoHeaderRow(validRepoHeaderRowList.size(), cells);
        finalHeaderRowList.add(bottomRow);
        String dataUrl = ReportRepoUtil.createIncomeMonthRepoDataUrl(bottomLevel, fromMonth, toMonth, bizCode, paytypeCode);
        String departmentName = "\u5168\u90e8\u4e8b\u4e1a\u90e8";
        IncomeBizMenu rootBizMenu = this.incomeBizMenuCache.getRootIncomeBizMenu(bizCode);
        if (rootBizMenu != null) {
            departmentName = rootBizMenu.getName();
        }
        String bizName = "\u5168\u90e8\u4e1a\u52a1\u7ebf";
        IncomeBizMenu bizMenu = this.incomeBizMenuCache.getBizMenuInfo().get(bizCode);
        if (bizMenu != null && !Strings.isNullOrEmpty((String)bizMenu.getParentcode())) {
            bizName = bizMenu.getName();
        }
        String paytypeName = "\u5168\u90e8\u6e20\u9053";
        IncomePaytypeMenu paytypeMenu = this.incomePaytypeMenuCache.getPaytypeMenuInfo().get(paytypeCode);
        if (paytypeMenu != null) {
            paytypeName = paytypeMenu.getName();
        }
        String excelTitle = ReportRepoUtil.createIncomeExcelName("\u4ea7\u54c1\u6536\u5165", departmentName, bizName, paytypeName, "\u6708\u6570\u636e");
        ArrayList dataArray = new ArrayList();
        for (int i3 = 0; i3 < finalHeaderRowList.size(); ++i3) {
            HashMap<String, List<RepoHeaderCell>> dataMap = new HashMap<String, List<RepoHeaderCell>>();
            dataMap.put("row", ((RepoHeaderRow)finalHeaderRowList.get(i3)).getCells());
            dataArray.add(dataMap);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("dataurl", dataUrl);
        dataMap.put("title", excelTitle);
        dataMap.put("tableheader", dataArray);
        return JSONUtil.fromObject(dataMap);
    }
}

