/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.bo;

import com.xunlei.channel.channelreport.dao.IncomeManMonthReportDao;
import com.xunlei.channel.channelreport.dao.IncomeMonthReportDao;
import com.xunlei.channel.channelreport.repo.cache.IncomeBizMenuCache;
import com.xunlei.channel.channelreport.repo.cache.IncomePaytypeMenuCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.util.Arith;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.json.JSONUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthRepoDataBo {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IncomeMonthReportDao incomeMonthReportDao;
    @Autowired
    IncomeManMonthReportDao incomeManMonthReportDao;
    @Autowired
    private IncomePaytypeMenuCache incomePaytypeMenuCache;
    @Autowired
    private IncomeBizMenuCache incomeBizMenuCache;
    @Autowired
    private IncomePaytypeinfoCache incomePaytypeinfoCache;
    private String paytypesPayAmtKey = "payamtpaytypestotal";
    private String paytypesSettleAmtKey = "settleamtpaytypestotal";
    private String paytypesRealAmtKey = "realamtpaytypestotal";
    private String paytypesPercentKey = "realpercentpaytypestotal";

    public String getBizMonthRepoData(int bottomLevel, String balanceFromMonth, String balanceToMonth, String bizCode, String paytypeCode, int pageNo, int pageSize) throws ParseException {
        DecimalFormat format = new DecimalFormat("0.00%");
        DecimalFormat moneyFormatter = new DecimalFormat("##,##0.00");
        ArrayList dataList = new ArrayList();
        Set<String> biznos = this.incomeBizMenuCache.getFieldBizInfo().get(bizCode);
        List<IncomePaytypeMenu> leafList = this.getBizCodeLeafPaytypeMenus(bizCode, paytypeCode);
        this.log.debug("leaf size:{}", (Object)leafList.size());
        HashSet<String> paytypeSet = new HashSet<String>();
        for (IncomePaytypeMenu leaf : leafList) {
            paytypeSet.add(leaf.getPaytype());
        }
        this.log.debug("leaf paytype size:{}", (Object)paytypeSet.size());
        Map<String, Map<String, Double>> dayReportDataList = this.incomeMonthReportDao.queryMonthReportData(balanceFromMonth, balanceToMonth, biznos, paytypeSet);
        Set<String> manMonthPaytypeSet = this.incomeManMonthReportDao.getManMonthPaytypeSet(balanceFromMonth, balanceToMonth);
        Calendar fromDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(new SimpleDateFormat("yyyy-MM").parse(balanceFromMonth));
        Calendar toDateCalendar = Calendar.getInstance();
        toDateCalendar.setTime(new SimpleDateFormat("yyyy-MM").parse(balanceToMonth));
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("balancemonth", "\u5408\u8ba1");
        Map<String, Set<String>> fieldPaytypeInfo = this.incomePaytypeMenuCache.getFieldPaytypeInfo();
        while (!toDateCalendar.before(fromDateCalendar)) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            boolean validBalancedate = false;
            String nowDate = new SimpleDateFormat("yyyy-MM").format(toDateCalendar.getTime());
            dataMap.put("balancemonth", nowDate);
            double monthTotalPayAmt = 0.0;
            double monthTotalSettleAmt = 0.0;
            double monthTotalRealAmt = 0.0;
            double monthTotalRefundAmt = 0.0;
            for (IncomePaytypeMenu leaf : leafList) {
                String fieldCode = leaf.getFieldcode();
                double totalPayAmt = 0.0;
                double totalSettleAmt = 0.0;
                double totalRealAmt = 0.0;
                double totalRefundAmt = 0.0;
                Set<String> cellPaytypes = fieldPaytypeInfo.get(fieldCode);
                boolean isManed = false;
                for (String paytype : cellPaytypes) {
                    String key = nowDate + paytype;
                    Map<String, Double> map = dayReportDataList.get(key);
                    if (map == null) continue;
                    if (manMonthPaytypeSet.contains(key)) {
                        isManed = true;
                    }
                    validBalancedate = true;
                    totalPayAmt = Arith.add(totalPayAmt, map.get("payamt"));
                    totalSettleAmt = Arith.add(totalSettleAmt, map.get("settleamt"));
                    totalRealAmt = Arith.add(totalRealAmt, map.get("realamt"));
                    totalRefundAmt = Arith.add(totalRefundAmt, map.get("refundamt"));
                    if (!"1".equals(this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A")).get("inrealrate"))) continue;
                    monthTotalPayAmt = Arith.add(monthTotalPayAmt, map.get("payamt"));
                    monthTotalSettleAmt = Arith.add(monthTotalSettleAmt, map.get("settleamt"));
                    monthTotalRealAmt = Arith.add(monthTotalRealAmt, map.get("realamt"));
                    monthTotalRefundAmt = Arith.add(monthTotalRefundAmt, map.get("refundamt"));
                }
                String payAmtKey = "payamt" + fieldCode;
                String settleAmtKey = "settleamt" + fieldCode;
                String realAmtKey = "realamt" + fieldCode;
                String percentKey = "realpercent" + fieldCode;
                double realPayAmt = Arith.add(totalPayAmt, totalRefundAmt);
                double realSettleAmt = Arith.add(totalSettleAmt, totalRefundAmt);
                double realRealAmt = Arith.add(totalRealAmt, totalRefundAmt);
                dataMap.put(payAmtKey, moneyFormatter.format(realPayAmt));
                dataMap.put(settleAmtKey, isManed ? "w" + moneyFormatter.format(realSettleAmt) : moneyFormatter.format(realSettleAmt));
                dataMap.put(realAmtKey, moneyFormatter.format(realRealAmt));
                dataMap.put(percentKey, realPayAmt == 0.0 ? "0.00%" : Arith.div(realRealAmt, realPayAmt, 5, format));
                if (totalMap.get(payAmtKey) == null) {
                    totalMap.put(payAmtKey, realPayAmt);
                } else {
                    totalMap.put(payAmtKey, Arith.add((Double)totalMap.get(payAmtKey), realPayAmt));
                }
                if (totalMap.get(settleAmtKey) == null) {
                    totalMap.put(settleAmtKey, realSettleAmt);
                } else {
                    totalMap.put(settleAmtKey, Arith.add((Double)totalMap.get(settleAmtKey), realSettleAmt));
                }
                if (totalMap.get(realAmtKey) == null) {
                    totalMap.put(realAmtKey, realRealAmt);
                    continue;
                }
                totalMap.put(realAmtKey, Arith.add((Double)totalMap.get(realAmtKey), realRealAmt));
            }
            double monthRealTotalPayAmt = Arith.add(monthTotalPayAmt, monthTotalRefundAmt);
            double monthRealTotalSettleAmt = Arith.add(monthTotalSettleAmt, monthTotalRefundAmt);
            double monthRealTotalRealAmt = Arith.add(monthTotalRealAmt, monthTotalRefundAmt);
            dataMap.put(this.paytypesPayAmtKey, moneyFormatter.format(monthRealTotalPayAmt));
            dataMap.put(this.paytypesSettleAmtKey, moneyFormatter.format(monthRealTotalSettleAmt));
            dataMap.put(this.paytypesRealAmtKey, moneyFormatter.format(monthRealTotalRealAmt));
            dataMap.put(this.paytypesPercentKey, monthRealTotalPayAmt == 0.0 ? "0.00%" : Arith.div(monthRealTotalRealAmt, monthRealTotalPayAmt, 5, format));
            if (totalMap.get(this.paytypesPayAmtKey) == null) {
                totalMap.put(this.paytypesPayAmtKey, monthRealTotalPayAmt);
            } else {
                totalMap.put(this.paytypesPayAmtKey, Arith.add((Double)totalMap.get(this.paytypesPayAmtKey), monthRealTotalPayAmt));
            }
            if (totalMap.get(this.paytypesSettleAmtKey) == null) {
                totalMap.put(this.paytypesSettleAmtKey, monthRealTotalSettleAmt);
            } else {
                totalMap.put(this.paytypesSettleAmtKey, Arith.add((Double)totalMap.get(this.paytypesSettleAmtKey), monthRealTotalSettleAmt));
            }
            if (totalMap.get(this.paytypesRealAmtKey) == null) {
                totalMap.put(this.paytypesRealAmtKey, monthRealTotalRealAmt);
            } else {
                totalMap.put(this.paytypesRealAmtKey, Arith.add((Double)totalMap.get(this.paytypesRealAmtKey), monthRealTotalRealAmt));
            }
            if (validBalancedate) {
                dataList.add(dataMap);
            }
            toDateCalendar.add(2, -1);
        }
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = pageNo * pageSize;
        int dataListSize = dataList.size();
        if (fromIndex > dataListSize) {
            dataList = new ArrayList();
        } else if (toIndex > dataListSize) {
            toIndex = dataListSize;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> footerList = new ArrayList<HashMap<String, Object>>();
        footerList.add(totalMap);
        for (IncomePaytypeMenu leaf : leafList) {
            String fieldCode = leaf.getFieldcode();
            String payAmtKey = "payamt" + fieldCode;
            String realAmtKey = "realamt" + fieldCode;
            Object payAmt = totalMap.get(payAmtKey);
            Object realAmt = totalMap.get(realAmtKey);
            String percentKey = "realpercent" + fieldCode;
            if (payAmt != null && realAmt != null) {
                totalMap.put(percentKey, (Double)payAmt == 0.0 ? "0.00%" : Arith.div((Double)realAmt, (Double)payAmt, 5, format));
                continue;
            }
            totalMap.put(percentKey, "0.00%");
        }
        Object paytypesPayAmt = totalMap.get(this.paytypesPayAmtKey);
        Object paytypesRealAmt = totalMap.get(this.paytypesRealAmtKey);
        if (paytypesPayAmt != null && paytypesRealAmt != null) {
            totalMap.put(this.paytypesPercentKey, (Double)paytypesPayAmt == 0.0 ? "0.00%" : Arith.div((Double)paytypesRealAmt, (Double)paytypesPayAmt, 5, format));
        } else {
            totalMap.put(this.paytypesPercentKey, "0.00%");
        }
        for (String key : totalMap.keySet()) {
            if (!(totalMap.get(key) instanceof Double)) continue;
            totalMap.put(key, moneyFormatter.format(totalMap.get(key)));
        }
        dataMap.put("total", dataList.size());
        dataMap.put("rows", dataList.subList(fromIndex, toIndex));
        dataMap.put("footer", footerList);
        return JSONUtil.fromObject(dataMap);
    }

    private List<IncomePaytypeMenu> getBizCodeLeafPaytypeMenus(String bizCode, String paytypeCode) {
        List<IncomePaytypeMenu> leafList = new ArrayList<IncomePaytypeMenu>();
        Map<String, List<IncomePaytypeMenu>> childrenMap = this.incomePaytypeMenuCache.getBizPaytypeMenuMap().get(bizCode);
        if (childrenMap.containsKey(paytypeCode)) {
            List<IncomePaytypeMenu> childList = childrenMap.get(paytypeCode);
            while (childList.size() > 0) {
                LinkedList<IncomePaytypeMenu> nextChildList = new LinkedList<IncomePaytypeMenu>();
                for (IncomePaytypeMenu child : childList) {
                    if (!childrenMap.containsKey(child.getFieldcode())) continue;
                    nextChildList.addAll((Collection<IncomePaytypeMenu>)childrenMap.get(child.getFieldcode()));
                }
                leafList = childList;
                childList = nextChildList;
            }
        }
        return leafList;
    }
}

