/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.repo.bo;

import com.xunlei.channel.channelreport.dao.IncomeDayReportDao;
import com.xunlei.channel.channelreport.repo.cache.IncomeBizMenuCache;
import com.xunlei.channel.channelreport.repo.cache.IncomePaytypeMenuCache;
import com.xunlei.channel.channelreport.statistics.cache.IncomePaytypeinfoCache;
import com.xunlei.channel.channelreport.util.Arith;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import com.xunlei.channel.channelreport.vo.IncomePaytypeMenu;
import com.xunlei.json.JSONUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayRepoDataBo {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IncomeDayReportDao incomeDayReportDao;
    @Autowired
    private IncomePaytypeMenuCache incomePaytypeMenuCache;
    @Autowired
    private IncomeBizMenuCache incomeBizMenuCache;
    @Autowired
    private IncomePaytypeinfoCache incomePaytypeinfoCache;
    private String paytypesPayAmtKey = "payamtpaytypestotal";
    private String paytypesSettleAmtKey = "settleamtpaytypestotal";

    public String getBizDayRepoData(int bottomLevel, String balanceFromDate, String balanceToDate, String bizCode, String paytypeCode, int pageNo, int pageSize) throws ParseException {
        DecimalFormat moneyFormatter = new DecimalFormat("##,##0.00");
        ArrayList dataList = new ArrayList();
        Set<String> biznos = this.incomeBizMenuCache.getFieldBizInfo().get(bizCode);
        List<IncomePaytypeMenu> leafList = this.getBizCodeLeafPaytypeMenus(bizCode, paytypeCode);
        this.log.debug("leaf size:{}", (Object)leafList.size());
        HashSet<String> paytypeSet = new HashSet<String>();
        for (IncomePaytypeMenu leaf : leafList) {
            paytypeSet.add(leaf.getPaytype());
        }
        this.log.debug("leaf paytype size:{}", (Object)paytypeSet.size());
        Map<String, HashMap<String, Double>> dayReportDataList = this.incomeDayReportDao.queryDayReportData(balanceFromDate, balanceToDate, biznos, paytypeSet);
        Calendar fromDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(balanceFromDate));
        Calendar toDateCalendar = Calendar.getInstance();
        toDateCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(balanceToDate));
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("balancedate", "\u5408\u8ba1");
        Map<String, Set<String>> fieldPaytypeInfo = this.incomePaytypeMenuCache.getFieldPaytypeInfo();
        while (!toDateCalendar.before(fromDateCalendar)) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            boolean validBalancedate = false;
            String nowDate = new SimpleDateFormat("yyyy-MM-dd").format(toDateCalendar.getTime());
            dataMap.put("balancedate", nowDate);
            double dayTotalPayAmt = 0.0;
            double dayTotalSettleAmt = 0.0;
            for (IncomePaytypeMenu leaf : leafList) {
                String fieldCode = leaf.getFieldcode();
                double totalPayAmt = 0.0;
                double totalSettleAmt = 0.0;
                Set<String> cellPaytypes = fieldPaytypeInfo.get(fieldCode);
                for (String paytype : cellPaytypes) {
                    String key = nowDate + paytype;
                    Map map = dayReportDataList.get(key);
                    if (map == null) continue;
                    validBalancedate = true;
                    totalPayAmt = Arith.add(totalPayAmt, (Double)map.get("payamt"));
                    totalSettleAmt = Arith.add(totalSettleAmt, (Double)map.get("settleamt"));
                    if (!"1".equals(this.incomePaytypeinfoCache.getPaytypeinfo(IncomeReportStatisticsUtil.joinPaytypeAndType(paytype, "A")).get("inrealrate"))) continue;
                    dayTotalPayAmt = Arith.add(dayTotalPayAmt, (Double)map.get("payamt"));
                    dayTotalSettleAmt = Arith.add(dayTotalSettleAmt, (Double)map.get("settleamt"));
                }
                String payAmtKey = "payamt" + fieldCode;
                String settleAmtKey = "settleamt" + fieldCode;
                dataMap.put(payAmtKey, moneyFormatter.format(totalPayAmt));
                dataMap.put(settleAmtKey, moneyFormatter.format(totalSettleAmt));
                if (totalMap.get(payAmtKey) == null) {
                    totalMap.put(payAmtKey, totalPayAmt);
                } else {
                    totalMap.put(payAmtKey, Arith.add((Double)totalMap.get(payAmtKey), totalPayAmt));
                }
                if (totalMap.get(settleAmtKey) == null) {
                    totalMap.put(settleAmtKey, totalSettleAmt);
                    continue;
                }
                totalMap.put(settleAmtKey, Arith.add((Double)totalMap.get(settleAmtKey), totalSettleAmt));
            }
            dataMap.put(this.paytypesPayAmtKey, moneyFormatter.format(dayTotalPayAmt));
            dataMap.put(this.paytypesSettleAmtKey, moneyFormatter.format(dayTotalSettleAmt));
            if (totalMap.get(this.paytypesPayAmtKey) == null) {
                totalMap.put(this.paytypesPayAmtKey, dayTotalPayAmt);
            } else {
                totalMap.put(this.paytypesPayAmtKey, Arith.add((Double)totalMap.get(this.paytypesPayAmtKey), dayTotalPayAmt));
            }
            if (totalMap.get(this.paytypesSettleAmtKey) == null) {
                totalMap.put(this.paytypesSettleAmtKey, dayTotalSettleAmt);
            } else {
                totalMap.put(this.paytypesSettleAmtKey, Arith.add((Double)totalMap.get(this.paytypesSettleAmtKey), dayTotalSettleAmt));
            }
            if (validBalancedate) {
                dataList.add(dataMap);
            }
            toDateCalendar.add(5, -1);
        }
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = pageNo * pageSize;
        int dataListSize = dataList.size();
        if (fromIndex > dataListSize) {
            dataList = new ArrayList();
        } else if (toIndex > dataListSize) {
            toIndex = dataListSize;
        }
        for (String key : totalMap.keySet()) {
            if ("balancedate".equals(key)) continue;
            totalMap.put(key, moneyFormatter.format(totalMap.get(key)));
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> footerList = new ArrayList<HashMap<String, Object>>();
        footerList.add(totalMap);
        dataMap.put("total", dataList.size());
        dataMap.put("rows", dataList.subList(fromIndex, toIndex));
        dataMap.put("footer", footerList);
        return JSONUtil.fromObject(dataMap);
    }

    private List<IncomePaytypeMenu> getBizCodeLeafPaytypeMenus(String bizCode, String paytypeCode) {
        List<IncomePaytypeMenu> leafList = new ArrayList<IncomePaytypeMenu>();
        Map<String, List<IncomePaytypeMenu>> childrenMap = this.incomePaytypeMenuCache.getBizPaytypeMenuMap().get(bizCode);
        if (childrenMap.containsKey(paytypeCode)) {
            List<IncomePaytypeMenu> childList = childrenMap.get(paytypeCode);
            while (childList.size() > 0) {
                LinkedList<IncomePaytypeMenu> nextChildList = new LinkedList<IncomePaytypeMenu>();
                for (IncomePaytypeMenu child : childList) {
                    if (!childrenMap.containsKey(child.getFieldcode())) continue;
                    nextChildList.addAll((Collection<IncomePaytypeMenu>)childrenMap.get(child.getFieldcode()));
                }
                leafList = childList;
                childList = nextChildList;
            }
        }
        return leafList;
    }
}

