/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.dao;

import com.xunlei.channel.channelreport.dao.AbstractDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class LeiMonthReportDao
extends AbstractDao {
    private static final Logger log = LoggerFactory.getLogger(LeiMonthReportDao.class);

    public void insert(String balanceMonth, String paytype, String realPaytype, double payAmt, double settleAmt, double realAmt) {
        log.info("insert balanceMonth:{},paytype:{},realpaytype:{},payamt:{},settleamt:{},realAmt:{}", new Object[]{balanceMonth, paytype, realPaytype, payAmt, settleAmt, realAmt});
        String sql = "insert into xlchannelreport.lei_monthreport(balancemonth,paytype,realpaytype,payamt,settleamt,realAmt) values(?,?,?,?,?,?);";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, paytype, realPaytype, payAmt, settleAmt, realAmt});
    }

    public void delete(String balanceMonth, String paytype) {
        log.info("delete balanceMonth:{},paytype:{}", new Object[]{balanceMonth, paytype});
        String sql = "delete from xlchannelreport.lei_monthreport where balancemonth=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, paytype});
    }

    public void deleteByPaytype(String balanceMonth, String paytype) {
        log.info("deleteByPaytype balancedate:{},paytype:{}", new Object[]{balanceMonth, paytype});
        String sql = "delete from xlchannelreport.lei_monthreport where balancemonth=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, paytype});
    }

    public void deleteByBalanceMonth(String balanceMonth) {
        log.info("deleteByBalanceDate balancemonth:{}", new Object[]{balanceMonth});
        String sql = "delete from xlchannelreport.lei_monthreport where balancemonth=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth});
    }

    public void deleteBySeqId(long seqid) {
        log.info("deleteBySeqId seqid", (Object)seqid);
        String sql = "delete from xlchannelreport.lei_monthreport where seqid=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{seqid});
    }

    public HashMap<String, Object> queryMonthSum(String balanceMonth, String paytype, String realPaytype) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("queryMonthSum balanceMonth:{},paytype:{},realpaytype:{}", new Object[]{balanceMonth, paytype, realPaytype});
        String sql = "select sum(payamt) as totalpayamt,sum(settleamt) as totalsettleamt from xlchannelreport.lei_dayreport where paytype=? and realpaytype=? and balancedate>=? and balancedate<=?;";
        return this.xlChannelReportJdbcTemplate.queryForMap(sql, new Object[]{paytype, realPaytype, fromDate, toDate});
    }

    public List<HashMap<String, Object>> getDistinctPaytypeAndRealPaytype(String balanceMonth) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctPaytypeAndRealPaytype balanceMonth:{}", new Object[]{balanceMonth});
        String sql = "select distinct paytype,realpaytype from xlchannelreport.lei_dayreport where balancedate>=? and balancedate<=?";
        return this.xlChannelReportJdbcTemplate.queryForMapList(sql, new Object[]{fromDate, toDate});
    }

    public List<String> getDistinctRealPaytypeByPaytype(String balanceMonth, String paytype) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctRealPaytypeByPaytype balanceMonth:{}", new Object[]{balanceMonth});
        String sql = "select distinct realpaytype from xlchannelreport.lei_dayreport where balancedate>=? and balancedate<=? and paytype=?";
        return this.xlChannelReportJdbcTemplate.queryForList(sql, new Object[]{fromDate, toDate, paytype}, String.class);
    }

    public Map<String, HashMap<String, Double>> queryMonthReportData(String fromDate, String toDate, Set<String> paytypes) {
        StringBuilder sql = new StringBuilder("select balancemonth,realpaytype,sum(payamt) as payamt,sum(settleamt) as settleamt,sum(realamt) as realamt from xlchannelreport.lei_monthreport where balancemonth>=? and balancemonth<=? ");
        boolean first = true;
        if (paytypes != null) {
            sql.append(" AND realpaytype in (");
            first = true;
            for (String paytype : paytypes) {
                if (first) {
                    sql.append("'").append(paytype).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(paytype).append("'");
            }
            sql.append(")");
        }
        sql.append(" group by realpaytype,balancemonth");
        final HashMap<String, HashMap<String, Double>> dataMap = new HashMap<String, HashMap<String, Double>>();
        this.xlChannelReportJdbcTemplate.query(sql.toString(), new Object[]{fromDate, toDate}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String balanceMonth = rs.getString("balancemonth");
                String realPaytype = rs.getString("realpaytype");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                Double realAmt = rs.getDouble("realamt");
                String key = balanceMonth + realPaytype;
                HashMap<String, Double> valueMap = new HashMap<String, Double>();
                valueMap.put("payamt", payAmt);
                valueMap.put("settleamt", settleAmt);
                valueMap.put("realamt", realAmt);
                dataMap.put(key, valueMap);
            }
        });
        return dataMap;
    }
}

