/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.dao;

import com.xunlei.channel.channelreport.dao.AbstractDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class LeiDayReportDao
extends AbstractDao {
    private static final Logger log = LoggerFactory.getLogger(LeiDayReportDao.class);

    public void insert(String balanceDate, String paytype, String realPaytype, double payAmt, double settleAmt) {
        log.info("insert balanceDate:{},paytype:{},realpaytype:{},payamt:{},settleamt:{}", new Object[]{balanceDate, paytype, realPaytype, payAmt, settleAmt});
        String sql = "insert into xlchannelreport.lei_dayreport(balancedate,paytype,realpaytype,payamt,settleamt) values(?,?,?,?,?);";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, paytype, realPaytype, payAmt, settleAmt});
    }

    public void delete(String balanceDate, String paytype) {
        log.info("delete balancedate:{},bizno:{},paytype:{}", new Object[]{balanceDate, paytype});
        String sql = "delete from xlchannelreport.lei_dayreport where balancedate=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, paytype});
    }

    public void deleteByPaytype(String balanceDate, String paytype) {
        log.info("deleteByPaytype balancedate:{},paytype:{}", new Object[]{balanceDate, paytype});
        String sql = "delete from xlchannelreport.lei_dayreport where balancedate=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, paytype});
    }

    public void deleteByBalanceDate(String balanceDate) {
        log.info("deleteByBalanceDate balancedate:{}", new Object[]{balanceDate});
        String sql = "delete from xlchannelreport.lei_dayreport where balancedate=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate});
    }

    public void deleteBySeqId(long seqid) {
        log.info("deleteBySeqId seqid:{}", (Object)seqid);
        String sql = "delete from xlchannelreport.lei_dayreport where seqid=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{seqid});
    }

    public double queryOrderAmtSumByBalanceDate(String sql, String balanceDate) throws Exception {
        log.info("query sql:{},balanceDate:{}", new Object[]{sql, balanceDate});
        Double value = 0.0;
        value = sql.contains("xlbonusbiz") ? (Double)this.xlBonusbizJdbcTemplate.queryForObject(sql, new Object[]{balanceDate}, Double.class) : (Double)this.xlPayProxyJdbcTemplate.queryForObject(sql, new Object[]{balanceDate}, Double.class);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public Map<String, HashMap<String, Double>> queryDayReportData(String fromDate, String toDate, Set<String> paytypes) {
        StringBuilder sql = new StringBuilder("select balancedate,realpaytype,sum(payamt) as payamt,sum(settleamt) as settleamt from xlchannelreport.lei_dayreport where balancedate>=? and balancedate<=? ");
        boolean first = true;
        if (paytypes != null) {
            sql.append(" AND realpaytype in (");
            first = true;
            for (String paytype : paytypes) {
                if (first) {
                    sql.append("'").append(paytype).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(paytype).append("'");
            }
            sql.append(")");
        }
        sql.append(" group by realpaytype,balancedate");
        final HashMap<String, HashMap<String, Double>> dataMap = new HashMap<String, HashMap<String, Double>>();
        this.xlChannelReportJdbcTemplate.query(sql.toString(), new Object[]{fromDate, toDate}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String balanceDate = rs.getString("balancedate");
                String realPaytype = rs.getString("realpaytype");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                String key = balanceDate + realPaytype;
                HashMap<String, Double> valueMap = new HashMap<String, Double>();
                valueMap.put("payamt", payAmt);
                valueMap.put("settleamt", settleAmt);
                dataMap.put(key, valueMap);
            }
        });
        return dataMap;
    }
}

