/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.dao;

import com.xunlei.channel.channelreport.dao.AbstractDao;
import com.xunlei.channel.channelreport.vo.MonthReport;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class IncomeMonthReportDao
extends AbstractDao {
    private static final Logger log = LoggerFactory.getLogger(IncomeMonthReportDao.class);

    public void insert(String balanceMonth, String bizno, String paytype, String realPaytype, double payAmt, double settleAmt, double refundAmt, double realAmt) {
        log.info("insert balanceMonth:{},bizno:{},paytype:{},realpaytype:{},payamt:{},settleamt:{},refundamt:{},realAmt:{}", new Object[]{balanceMonth, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, realAmt});
        String sql = "insert into xlchannelreport.income_monthreport(balancemonth,bizno,paytype,realpaytype,payamt,settleamt,refundamt,realAmt) values(?,?,?,?,?,?,?,?);";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, realAmt});
    }

    public void delete(String balanceMonth, String bizno, String paytype) {
        log.info("delete balanceMonth:{},bizno:{},paytype:{}", new Object[]{balanceMonth, bizno, paytype});
        String sql = "delete from xlchannelreport.income_monthreport where balancemonth=? and bizno=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, bizno, paytype});
    }

    public void deleteByPaytype(String balanceMonth, String paytype) {
        log.info("deleteByPaytype balancedate:{},paytype:{}", new Object[]{balanceMonth, paytype});
        String sql = "delete from xlchannelreport.income_monthreport where balancemonth=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, paytype});
    }

    public void deleteByBizno(String balanceMonth, String bizno) {
        log.info("deleteByBizno balancemonth:{},bizno:{}", new Object[]{balanceMonth, bizno});
        String sql = "delete from xlchannelreport.income_monthreport where balancemonth=? and bizno=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, bizno});
    }

    public void deleteByBalanceMonth(String balanceMonth) {
        log.info("deleteByBalanceDate balancemonth:{}", new Object[]{balanceMonth});
        String sql = "delete from xlchannelreport.income_monthreport where balancemonth=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth});
    }

    public void deleteBySeqId(long seqid) {
        log.info("deleteBySeqId seqid", (Object)seqid);
        String sql = "delete from xlchannelreport.income_monthreport where seqid=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{seqid});
    }

    public Map<String, Object> queryMonthSum(String balanceMonth, String paytype, String realPaytype, String bizno) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("queryMonthSum balanceMonth:{},paytype:{},realpaytype:{},bizno:{}", new Object[]{balanceMonth, paytype, realPaytype, bizno});
        String sql = "select sum(payamt) as totalpayamt,sum(settleamt) as totalsettleamt,sum(refundamt) as totalrefundamt from xlchannelreport.income_dayreport where paytype=? and bizno=? and realpaytype=? and balancedate>=? and balancedate<=?;";
        return this.xlChannelReportJdbcTemplate.queryForMap(sql, new Object[]{paytype, bizno, realPaytype, fromDate, toDate});
    }

    public List<HashMap<String, Object>> getDistinctBiznoAndPaytypeAndRealPaytype(String balanceMonth) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctBiznoAndPaytype balanceMonth:{}", new Object[]{balanceMonth});
        String sql = "select distinct bizno,paytype,realpaytype from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=?";
        return this.xlChannelReportJdbcTemplate.queryForMapList(sql, new Object[]{fromDate, toDate});
    }

    public List<HashMap<String, Object>> getDistinctPaytypeAndRealPaytypeByBizno(String balanceMonth, String bizno) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctPaytypeAndRealPaytypeByBizno...balanceMonth:{},bizno:{}", new Object[]{balanceMonth, bizno});
        String sql = "select distinct bizno,paytype,realpaytype from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=? and bizno=?";
        return this.xlChannelReportJdbcTemplate.queryForMapList(sql, new Object[]{fromDate, toDate, bizno});
    }

    public List<String> getDistinctBizno(String balanceMonth) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctBizno balanceMonth:{}", new Object[]{balanceMonth});
        String sql = "select distinct bizno from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=?";
        return this.xlChannelReportJdbcTemplate.queryForList(sql, new Object[]{fromDate, toDate}, String.class);
    }

    public List<String> getDistinctRealPaytypeByPaytype(String balanceMonth, String paytype) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getDistinctPaytype balanceMonth:{}", new Object[]{balanceMonth});
        String sql = "select distinct realpaytype from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=? and paytype=?";
        return this.xlChannelReportJdbcTemplate.queryForList(sql, new Object[]{fromDate, toDate, paytype}, String.class);
    }

    public Map<String, Map<String, Double>> queryMonthReportData(String fromDate, String toDate, Set<String> biznos, Set<String> paytypes) {
        StringBuilder sql = new StringBuilder("select balancemonth,realpaytype,sum(payamt) as payamt,sum(settleamt) as settleamt,sum(refundamt) as refundamt,sum(realamt) as realamt from xlchannelreport.income_monthreport where balancemonth>=? and balancemonth<=? ");
        boolean first = true;
        if (biznos != null) {
            sql.append(" AND bizno in (");
            for (String bizno : biznos) {
                if (first) {
                    sql.append("'").append(bizno).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(bizno).append("'");
            }
            sql.append(")");
        }
        if (paytypes != null) {
            sql.append(" AND realpaytype in (");
            first = true;
            for (String paytype : paytypes) {
                if (first) {
                    sql.append("'").append(paytype).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(paytype).append("'");
            }
            sql.append(")");
        }
        sql.append(" group by realpaytype,balancemonth");
        log.debug("sql:{}", (Object)sql);
        final HashMap<String, Map<String, Double>> dataMap = new HashMap<String, Map<String, Double>>();
        this.xlChannelReportJdbcTemplate.query(sql.toString(), new Object[]{fromDate, toDate}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String balanceMonth = rs.getString("balancemonth");
                String realPaytype = rs.getString("realpaytype");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                Double refundAmt = rs.getDouble("refundamt");
                Double realAmt = rs.getDouble("realamt");
                String key = balanceMonth + realPaytype;
                HashMap<String, Double> valueMap = new HashMap<String, Double>();
                valueMap.put("payamt", payAmt);
                valueMap.put("settleamt", settleAmt);
                valueMap.put("refundamt", refundAmt);
                valueMap.put("realamt", realAmt);
                dataMap.put(key, valueMap);
            }
        });
        return dataMap;
    }

    public void deleteByBiznoAndPaytype(String balanceMonth, String bizno, String paytype) {
        log.info("deleteByBiznoAndPaytype balancemonth:{},bizno:{},paytype:{}", new Object[]{balanceMonth, bizno, paytype});
        String sql = "delete from xlchannelreport.income_monthreport where balancemonth=? and bizno=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceMonth, bizno, paytype});
    }

    public List<MonthReport> getMonthReportList(final String balanceMonth) {
        String fromDate = balanceMonth + "-01";
        String toDate = balanceMonth + "-31";
        log.info("getMonthReportList...balanceMonth:{}", (Object)balanceMonth);
        String sql = "select bizno,paytype,sum(payamt) as totalpayamt,sum(settleamt) as totalsettleamt,sum(refundamt) as totalrefundamt from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=? group by bizno,paytype";
        return this.xlChannelReportJdbcTemplate.query(sql, new Object[]{fromDate, toDate}, new RowMapper(){

            public MonthReport mapRow(ResultSet rs, int rowNum) throws SQLException {
                MonthReport mr = new MonthReport();
                mr.setBalanceMonth(balanceMonth);
                mr.setBizno(rs.getString(1));
                mr.setPaytype(rs.getString(2));
                mr.setPayAmt(rs.getDouble(3));
                mr.setSettleamt(rs.getDouble(4));
                mr.setRefundamt(rs.getDouble(5));
                mr.setRealamt(mr.getSettleamt());
                return mr;
            }
        });
    }

    public void bathInsertMonthReport(final List<MonthReport> monthReportList) {
        String sql = "insert into income_monthreport(balancemonth,bizno,paytype,realpaytype,payamt,settleamt,refundamt,realamt) values (?,?,?,?,?,?,?,?)";
        this.xlChannelReportJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, ((MonthReport)monthReportList.get(i)).getBalanceMonth());
                ps.setString(2, ((MonthReport)monthReportList.get(i)).getBizno());
                ps.setString(3, ((MonthReport)monthReportList.get(i)).getPaytype());
                ps.setString(4, ((MonthReport)monthReportList.get(i)).getRealpaytype());
                ps.setDouble(5, ((MonthReport)monthReportList.get(i)).getPayAmt());
                ps.setDouble(6, ((MonthReport)monthReportList.get(i)).getSettleamt());
                ps.setDouble(7, ((MonthReport)monthReportList.get(i)).getRefundamt());
                ps.setDouble(8, ((MonthReport)monthReportList.get(i)).getRealamt());
            }

            public int getBatchSize() {
                return monthReportList.size();
            }
        });
    }
}

