/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.dao;

import com.google.common.base.Strings;
import com.xunlei.channel.channelreport.dao.AbstractDao;
import com.xunlei.channel.channelreport.util.IncomeReportStatisticsUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class IncomeManMonthReportDao
extends AbstractDao {
    private static final Logger log = LoggerFactory.getLogger(IncomeManMonthReportDao.class);

    public List<HashMap<String, Object>> getManMonthReportMapList(String orderBy) {
        if (Strings.isNullOrEmpty((String)orderBy)) {
            orderBy = "seqid";
        }
        String sql = "select seqid,balancemonth,bizno,paytype,realpaytype,realamt,editby from xlchannelreport.income_manmonthreport order by ?";
        return this.xlChannelReportJdbcTemplate.queryForMapList(sql, new Object[]{orderBy});
    }

    public Map<String, Double> getAmtMapByMonth(String balanceMonth) {
        String sql = "select bizno,paytype,realpaytype,realamt,payamt,settleamt,refundamt from xlchannelreport.income_manmonthreport where balancemonth=?";
        final HashMap<String, Double> map = new HashMap<String, Double>();
        this.xlChannelReportJdbcTemplate.query(sql, new Object[]{balanceMonth}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String bizno = rs.getString("bizno");
                String paytype = rs.getString("paytype");
                String realPaytype = rs.getString("realpaytype");
                Double realAmt = rs.getDouble("realamt");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                Double refundAmt = rs.getDouble("refundamt");
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"), realAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"), settleAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"), refundAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"), payAmt);
            }
        });
        return map;
    }

    public Map<String, Double> getAmtMapByMonthAndBizno(String balanceMonth, String bizno) {
        String sql = "select bizno,paytype,realpaytype,realamt,payamt,settleamt,refundamt from xlchannelreport.income_manmonthreport where balancemonth=? and bizno=?";
        final HashMap<String, Double> map = new HashMap<String, Double>();
        this.xlChannelReportJdbcTemplate.query(sql, new Object[]{balanceMonth, bizno}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String bizno = rs.getString("bizno");
                String paytype = rs.getString("paytype");
                String realPaytype = rs.getString("realpaytype");
                Double realAmt = rs.getDouble("realamt");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                Double refundAmt = rs.getDouble("refundamt");
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "realamt"), realAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "settleamt"), settleAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "refundamt"), refundAmt);
                map.put(IncomeReportStatisticsUtil.joinBiznoAndPaytypeAndRealPaytypeAndAmtName(bizno, paytype, realPaytype, "payamt"), payAmt);
            }
        });
        return map;
    }

    public Set<String> getManMonthPaytypeSet(String balanceFromMonth, String balanceToMonth) {
        String sql = "select realpaytype,balancemonth from xlchannelreport.income_manmonthreport where balancemonth>=? and balancemonth<=?";
        log.debug(sql);
        final HashSet<String> set = new HashSet<String>();
        this.xlChannelReportJdbcTemplate.query(sql, new Object[]{balanceFromMonth, balanceToMonth}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String balanceMonth = rs.getString("balancemonth");
                String realPaytype = rs.getString("realpaytype");
                set.add(balanceMonth + realPaytype);
            }
        });
        return set;
    }
}

