/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.channelreport.dao;

import com.xunlei.channel.channelreport.dao.AbstractDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class IncomeDayReportDao
extends AbstractDao {
    private static final Logger log = LoggerFactory.getLogger(IncomeDayReportDao.class);

    public void insert(String balanceDate, String bizno, String paytype, String realPaytype, double payAmt, double settleAmt, double refundAmt, double payuserAmt) {
        log.info("insert balanceDate:{},bizno:{},paytype:{},realpaytype:{},payamt:{},settleamt:{},refundamt:{},payuserAmt:{}", new Object[]{balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt});
        String sql = "insert into xlchannelreport.income_dayreport(balancedate,bizno,paytype,realpaytype,payamt,settleamt,refundamt,payuseramt) values(?,?,?,?,?,?,?,?);";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, bizno, paytype, realPaytype, payAmt, settleAmt, refundAmt, payuserAmt});
    }

    public void delete(String balanceDate, String bizno, String paytype) {
        log.info("delete balancedate:{},bizno:{},paytype:{}", new Object[]{balanceDate, bizno, paytype});
        String sql = "delete from xlchannelreport.income_dayreport where balancedate=? and bizno=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, bizno, paytype});
    }

    public void deleteByPaytype(String balanceDate, String paytype) {
        log.info("deleteByPaytype balancedate:{},paytype:{}", new Object[]{balanceDate, paytype});
        String sql = "delete from xlchannelreport.income_dayreport where balancedate=? and paytype=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, paytype});
    }

    public void deleteByBizno(String balanceDate, String bizno) {
        log.info("deleteByBizno balancedate:{},bizno:{}", new Object[]{balanceDate, bizno});
        String sql = "delete from xlchannelreport.income_dayreport where balancedate=? and bizno=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate, bizno});
    }

    public void deleteByBalanceDate(String balanceDate) {
        log.info("deleteByBalanceDate balancedate:{}", new Object[]{balanceDate});
        String sql = "delete from xlchannelreport.income_dayreport where balancedate=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{balanceDate});
    }

    public void deleteBySeqId(long seqid) {
        log.info("deleteBySeqId seqid:{}", (Object)seqid);
        String sql = "delete from xlchannelreport.income_dayreport where seqid=?;";
        this.xlChannelReportJdbcTemplate.update(sql, new Object[]{seqid});
    }

    public double queryOrderAmtSumByBalanceDate(String sql, String balanceDate) throws Exception {
        log.info("query sql:{},balanceDate:{}", new Object[]{sql, balanceDate});
        Double value = (Double)this.xlPayProxyJdbcTemplate.queryForObject(sql, new Object[]{balanceDate}, Double.class);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public Map<String, HashMap<String, Double>> queryDayReportData(String fromDate, String toDate, Set<String> biznos, Set<String> paytypes) {
        StringBuilder sql = new StringBuilder("select balancedate,realpaytype,sum(payamt) as payamt,sum(settleamt) as settleamt,sum(refundamt) as refundamt from xlchannelreport.income_dayreport where balancedate>=? and balancedate<=? ");
        boolean first = true;
        if (biznos != null) {
            sql.append(" AND bizno in (");
            for (String bizno : biznos) {
                if (first) {
                    sql.append("'").append(bizno).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(bizno).append("'");
            }
            sql.append(")");
        }
        if (paytypes != null) {
            sql.append(" AND realpaytype in (");
            first = true;
            for (String paytype : paytypes) {
                if (first) {
                    sql.append("'").append(paytype).append("'");
                    first = false;
                    continue;
                }
                sql.append(",'").append(paytype).append("'");
            }
            sql.append(")");
        }
        sql.append(" group by realpaytype,balancedate");
        log.debug(sql.toString());
        final HashMap<String, HashMap<String, Double>> dataMap = new HashMap<String, HashMap<String, Double>>();
        this.xlChannelReportJdbcTemplate.query(sql.toString(), new Object[]{fromDate, toDate}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String balanceDate = rs.getString("balancedate");
                String realPaytype = rs.getString("realpaytype");
                Double payAmt = rs.getDouble("payamt");
                Double settleAmt = rs.getDouble("settleamt");
                Double refundAmt = rs.getDouble("refundamt");
                String key = balanceDate + realPaytype;
                HashMap<String, Double> valueMap = new HashMap<String, Double>();
                valueMap.put("payamt", payAmt);
                valueMap.put("settleamt", settleAmt);
                valueMap.put("refundamt", refundAmt);
                dataMap.put(key, valueMap);
            }
        });
        return dataMap;
    }

    public Map<String, Double> getDayBizPaytypeOrderamt(String balanceDate) {
        final TreeMap<String, Double> map = new TreeMap<String, Double>();
        this.xlChannelReportJdbcTemplate.query("select bizno,paytype,sum(orderamt) from xlpayproxy.bizorderok where balancedate=? and type='A' group by bizno,paytype", new Object[]{balanceDate}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String bizno = rs.getString(1);
                String paytype = rs.getString(2);
                Double orderAmt = rs.getDouble(3);
                map.put(bizno + "_" + paytype + "_" + "A", orderAmt);
            }
        });
        return map;
    }

    public Map<String, Double> getDayPaytypeOrderamt(String balanceDate, String payType) {
        final TreeMap<String, Double> map = new TreeMap<String, Double>();
        this.xlChannelReportJdbcTemplate.query("select bizno,sum(orderamt) from xlpayproxy.bizorderok where balancedate=? and paytype=? and type='A' group by bizno", new Object[]{balanceDate, payType}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String bizno = rs.getString(1);
                Double orderAmt = rs.getDouble(2);
                map.put(bizno, orderAmt);
            }
        });
        return map;
    }

    public Map<String, Double> getDayBizOrderamt(String balanceDate, String bizno) {
        final TreeMap<String, Double> map = new TreeMap<String, Double>();
        this.xlChannelReportJdbcTemplate.query("select paytype,sum(orderamt) from xlpayproxy.bizorderok where balancedate=? and bizno=? and type='A' group by paytype", new Object[]{balanceDate, bizno}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String paytype = rs.getString(1);
                Double orderAmt = rs.getDouble(2);
                map.put(paytype, orderAmt);
            }
        });
        return map;
    }
}

