/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.web.model;

import com.xunlei.card.util.Utility;
import com.xunlei.card.vo.Sppayapply;
import com.xunlei.card.web.model.BaseManagedBean;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.Users;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

@FunRef(value="Sppayapply")
public class SppayapplyManagedBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(SppayapplyManagedBean.class);

    private Sppayapply findQueryBean() {
        Sppayapply bean = (Sppayapply)this.findBean(Sppayapply.class, 2);
        if (this.isEmpty(bean.getApplystatus()) && this.isEmpty(bean.getFromdate()) && this.isEmpty(bean.getTodate())) {
            String checkrole = this.getUserCheckrole();
            if (checkrole.equals("CHE-01")) {
                String[] someapplyStatus = new String[]{"0", "1"};
                bean.setSomeapplystatus(someapplyStatus);
                bean.setApplystatus("0");
            } else if (checkrole.equals("CHE-04")) {
                String[] someapplyStatus = new String[]{"0"};
                bean.setSomeapplystatus(someapplyStatus);
                bean.setApplystatus("0");
            }
        }
        if (this.isEmpty(bean.getFromdate())) {
            bean.setFromdate(Utility.addDate(Utility.dateofnow(), "D", -30));
        }
        if (this.isEmpty(bean.getTodate())) {
            bean.setTodate(DatetimeUtil.today());
        }
        if (this.isEmpty(bean.getBillarea())) {
            bean.setBillarea("C");
        }
        return bean;
    }

    public String getQuerySppayapplylist() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("ApplyNoteCd desc");
        fliper.setPageSize(20);
        Sppayapply bean = this.findQueryBean();
        double sumpayamt = facade.getSumPayamtForquerySppayapply(bean);
        Sheet<Sppayapply> sheet = facade.querySppayapply(bean, fliper);
        logger.debug((Object)("sumpayamt=" + sumpayamt));
        logger.debug((Object)("rowcount=" + sheet.getRowcount()));
        double pagepayamt = 0.0;
        DecimalFormat df = new DecimalFormat("###0.00");
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            int pagecount = (sheet.getRowcount() + fliper.getPageSize() - 1) / fliper.getPageSize();
            for (Sppayapply sppayapply : list) {
                pagepayamt += sppayapply.getPayamt();
            }
            Sppayapply pagestat = new Sppayapply();
            pagestat.setApplynotecd("\u672c\u9875\u5c0f\u8ba1");
            pagestat.setPayamt(Double.valueOf(df.format(pagepayamt)));
            list.add(pagestat);
            Sppayapply sumstat = new Sppayapply();
            sumstat.setApplynotecd("\u603b\u8ba1");
            sumstat.setPayamt(Double.valueOf(df.format(sumpayamt)));
            list.add(sumstat);
            Sheet displaysheet = new Sheet(sheet.getRowcount() + pagecount * 2, (Collection)list);
            fliper.setPageSize(fliper.getPageSize() + 2);
            this.mergePagedDataModel(displaysheet, new PagedFliper[]{fliper});
        } else {
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String delete() {
        this.authenticateDel();
        long seqid = this.findParamLong("one_seqid");
        try {
            Sppayapply c = facade.getSppayapplyById(seqid);
            logger.debug((Object)("applynotecd=" + c.getApplynotecd()));
            if (c.getSppartnerid().equals("100004")) {
                Sppayapply qdata = new Sppayapply();
                qdata.setApplynotecd(c.getApplynotecd());
                qdata.setBillarea("A");
                Sppayapply sa = facade.findSppayapply(qdata);
                if (sa != null) {
                    facade.deleteSppayapplyById(sa.getSeqid());
                }
                qdata.setBillarea("B");
                Sppayapply sb = facade.findSppayapply(qdata);
                if (sb != null) {
                    facade.deleteSppayapplyById(sb.getSeqid());
                }
            }
            facade.deleteSppayapplyById(seqid);
        }
        catch (XLRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "go_back";
    }

    public String getEditedRecord() {
        logger.debug((Object)("######" + this.findParameter("sseqid")));
        long seqid = this.findParamLong("sseqid");
        if (seqid != 0L) {
            Sppayapply c = facade.getSppayapplyById(seqid);
            logger.debug((Object)("status=" + c.getApplystatus()));
            if (c.getSppartnerid().equals("100004")) {
                Sppayapply qdata = new Sppayapply();
                qdata.setApplynotecd(c.getApplynotecd());
                qdata.setBillarea("A");
                Sppayapply sa = facade.findSppayapply(qdata);
                if (sa != null) {
                    c.setPayamta(sa.getPayamt());
                    c.setBalancemontha(sa.getBalancemonth());
                }
                qdata.setBillarea("B");
                Sppayapply sb = facade.findSppayapply(qdata);
                if (sb != null) {
                    c.setPayamtb(sb.getPayamt());
                    c.setBalancemonthb(sb.getBalancemonth());
                }
            }
            this.mergeBean(c);
            this.mergeBean(this.getFliper(), "fliper");
        }
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        long[] lArray = this.findParamSeqids();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long seqid = lArray[n2];
            facade.deleteSppayapplyById(seqid);
            ++n2;
        }
        return "";
    }

    public void answerToEmail(Sppayapply data) {
        HashMap<String, String> mailParams = new HashMap<String, String>();
        mailParams.put("fromaddress", "xlpay@xunlei.com");
        String toaddress = null;
        String sppartnername = (String)LibClassM.getStringValues((String)"SppartnerId").get(data.getSppartnerid());
        if (data.getApplystatus().equals("0")) {
            toaddress = this.finderToAddress("CHE-04");
            logger.debug((Object)("\u8d22\u52a1\u4eba\u5458toaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", sppartnername + "\u7ed3\u7b97\u4ed8\u6b3e\u7533\u8bf7\u5f85\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + Users.findUser((String)data.getApplyby()).getTruename() + "&nbsp;" + data.getApplytime() + "\u65b0\u589e" + sppartnername + "&nbsp;\u7ed3\u7b97\u4ed8\u6b3e\u7533\u8bf7\u5f85\u5ba1\u6838\u3002<br>" + "\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        } else if (data.getApplystatus().equals("1")) {
            toaddress = this.finderToAddress("CHE-01");
            logger.debug((Object)("\u5546\u670dtoaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", sppartnername + "\u7ed3\u7b97\u4ed8\u6b3e\u7533\u8bf7\u672a\u901a\u8fc7\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + sppartnername + "&nbsp;" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u672a\u901a\u8fc7\u8d22\u52a1\u4eba\u5458\u5ba1\u6838\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        } else if (data.getApplystatus().equals("2")) {
            toaddress = this.finderToAddress("CHE-01");
            logger.debug((Object)("\u5546\u670dtoaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", sppartnername + "\u7ed3\u7b97\u4ed8\u6b3e\u7533\u8bf7\u901a\u8fc7\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + sppartnername + "&nbsp;" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u901a\u8fc7\u8d22\u52a1\u4eba\u5458\u5ba1\u6838\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
            toaddress = String.valueOf(this.finderToAddress("CHE-03")) + ";" + this.finderToAddress("CHE-02");
            logger.debug((Object)("\u7ba1\u7406\u5c42\u3001\u4e3b\u7ba1toaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", sppartnername + "\u7ed3\u7b97\u4ed8\u6b3e");
            rspStr = "";
            content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + sppartnername + "\u4e8e" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        }
    }

    public String add() {
        logger.debug((Object)"add----");
        this.authenticateAdd();
        Sppayapply data = (Sppayapply)this.findBean(Sppayapply.class);
        try {
            String applynotecd = facade.createApplyNoteCd("I");
            data.setApplynotecd(applynotecd);
            data.setBillarea("C");
            data.setApplyby(this.currentUserLogo());
            data.setApplytime(this.now());
            data.setApplyip(this.currentUserLogIP());
            data.setApplyremark(data.getApplyremark());
            data.setApplystatus("0");
            data.setCheck1result("0");
            data.setVerid(1L);
            facade.insertSppayapply(data);
            this.answerToEmail(data);
        }
        catch (Exception e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Sppayapply data = (Sppayapply)this.findBean(Sppayapply.class);
        data.setApplystatus("0");
        data.setCheck1result("0");
        data.setApplyby(this.currentUserLogo());
        data.setApplytime(this.now());
        data.setApplyip(this.currentUserLogIP());
        try {
            if (!facade.findSppayapply(data).getApplystatus().equals("0") && !facade.findSppayapply(data).getApplystatus().equals("")) {
                this.answerToEmail(data);
            }
            facade.updateSppayapply(data);
        }
        catch (Exception e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public String getUMPSppayapply() {
        logger.debug((Object)"getUMPSppayapply()");
        Sppayapply bean = (Sppayapply)this.findBean(Sppayapply.class);
        if (bean != null) {
            Sppayapply qdata = new Sppayapply();
            qdata.setApplynotecd(bean.getApplynotecd());
            qdata.setBillarea("A");
            Sppayapply sa = facade.findSppayapply(qdata);
            if (sa != null) {
                bean.setPayamta(sa.getPayamt());
                bean.setBalancemontha(sa.getBalancemonth());
            }
            qdata.setBillarea("B");
            Sppayapply sb = facade.findSppayapply(qdata);
            if (sb != null) {
                bean.setPayamtb(sb.getPayamt());
                bean.setBalancemonthb(sb.getBalancemonth());
            }
        }
        this.mergeBean(bean);
        logger.debug((Object)"end getUMPSppayapply!");
        return "";
    }

    public String auditYes() {
        this.authenticateEdit();
        Sppayapply newdata = (Sppayapply)this.findBean(Sppayapply.class);
        try {
            Sppayapply data = facade.getSppayapplyById(newdata.getSeqid());
            logger.debug((Object)("auditYes--seqid()=" + newdata.getSeqid() + " remark=" + newdata.getCheck1remark() + " verid=" + newdata.getVerid()));
            logger.debug((Object)("payamta=" + newdata.getPayamta() + ",montha=" + newdata.getBalancemontha() + ",payamtb=" + newdata.getPayamtb() + ",monthb=" + newdata.getBalancemonthb()));
            data.setCheck1by(this.currentUserLogo());
            data.setCheck1time(this.now());
            data.setCheck1ip(this.currentUserLogIP());
            data.setCheck1remark(newdata.getCheck1remark());
            data.setCheck1result("1");
            data.setApplystatus("2");
            data.setVerid(newdata.getVerid());
            data.setPayamta(newdata.getPayamta());
            data.setBalancemontha(newdata.getBalancemontha());
            data.setPayamtb(newdata.getPayamtb());
            data.setBalancemonthb(newdata.getBalancemonthb());
            facade.updateSppayapply(data);
            this.answerToEmail(data);
            this.mergeBean("OK", "jsmessage");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public String auditNo() {
        this.authenticateEdit();
        Sppayapply newdata = (Sppayapply)this.findBean(Sppayapply.class);
        try {
            Sppayapply data = facade.getSppayapplyById(newdata.getSeqid());
            logger.debug((Object)("auditNo--seqid()=" + newdata.getSeqid() + " remark=" + newdata.getCheck1remark() + " verid=" + newdata.getVerid()));
            data.setCheck1by(this.currentUserLogo());
            data.setCheck1time(this.now());
            data.setCheck1ip(this.currentUserLogIP());
            data.setCheck1remark(newdata.getCheck1remark());
            data.setCheck1result("2");
            data.setApplystatus("1");
            data.setVerid(newdata.getVerid());
            data.setPayamta(newdata.getPayamta());
            data.setBalancemontha(newdata.getBalancemontha());
            data.setPayamtb(newdata.getPayamtb());
            data.setBalancemonthb(newdata.getBalancemonthb());
            facade.updateSppayapply(data);
            this.answerToEmail(data);
            this.mergeBean("OK", "jsmessage");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public List<SelectItem> getSppartners() {
        ArrayList<SelectItem> items = (ArrayList<SelectItem>)this.getRequestAttribute("sppartners");
        if (items == null) {
            List list = LibClassM.getLibClassDList((String)"SppartnerId");
            items = new ArrayList<SelectItem>();
            for (LibClassD ld : list) {
                if (!ld.getItemvalue().equals("N")) continue;
                items.add(new SelectItem((Object)ld.getItemno(), ld.getItemname()));
            }
            this.setRequestAttribute("sppartners", items);
        }
        return items;
    }

    public Hashtable<String, String> getSppartnersMap() {
        Hashtable ht = (Hashtable)this.getRequestAttribute("sppartnersMap");
        if (ht == null) {
            ht = new Hashtable();
            List list = LibClassM.getLibClassDList((String)"SppartnerId");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(list.size());
            for (LibClassD ld : list) {
                if (!ld.getItemvalue().equals("N")) continue;
                map.put(ld.getItemno(), ld.getItemname());
            }
            ht.putAll(map);
            this.setRequestAttribute("sppartnersMap", ht);
        }
        return ht;
    }

    public List<SelectItem> getAllapplyStatuses() {
        ArrayList<SelectItem> items = (ArrayList<SelectItem>)this.getRequestAttribute("CopPaymentApplySts");
        if (items == null) {
            Map map = LibClassM.getStringValues((String)"CopPaymentApplySts");
            items = new ArrayList<SelectItem>(map.size());
            for (Map.Entry en : map.entrySet()) {
                items.add(new SelectItem(en.getKey(), (String)en.getValue()));
            }
            this.setRequestAttribute("CopPaymentApplySts", items);
        }
        return items;
    }

    public Hashtable<String, String> getAllapplyStatusesMap() {
        Hashtable ht = (Hashtable)this.getRequestAttribute("CopPaymentApplyStsMap");
        if (ht == null) {
            ht = new Hashtable();
            Map map = LibClassM.getStringValues((String)"CopPaymentApplySts");
            ht.putAll(map);
            this.setRequestAttribute("CopPaymentApplyStsMap", ht);
        }
        return ht;
    }
}

