/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.web.model;

import com.xunlei.card.util.ApplicationConfigUtil;
import com.xunlei.card.util.PayCenter2AppConfigUtil;
import com.xunlei.card.util.Utility;
import com.xunlei.card.util.XLCardRuntimeException;
import com.xunlei.card.vo.Placards;
import com.xunlei.card.web.model.BaseManagedBean;
import com.xunlei.common.util.FileUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.pay.facade.IFacade;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

@FunRef(value="Placards")
public class PlacardsManagedBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(PlacardsManagedBean.class);
    private UploadedFile ufile;
    private SelectItem[] flatNos;
    private SelectItem[] placardstype;
    private SelectItem[] cardflag;
    private Hashtable<String, String> flatNosMap;
    private Hashtable<String, String> placardstypeMap;

    public SelectItem[] getCardflag() {
        if (this.cardflag != null) {
            return this.cardflag;
        }
        SelectItem[] items = new SelectItem[]{new SelectItem((Object)0, "\u5185\u5bb9"), new SelectItem((Object)1, "\u94fe\u63a5")};
        this.cardflag = items;
        return items;
    }

    public SelectItem[] getStates() {
        SelectItem[] items = new SelectItem[]{new SelectItem((Object)"\u5373\u5c06\u5f00\u59cb", "\u5373\u5c06\u5f00\u59cb"), new SelectItem((Object)"\u8fdb\u884c\u4e2d", "\u8fdb\u884c\u4e2d"), new SelectItem((Object)"\u5df2\u7ecf\u7ed3\u675f", "\u5df2\u7ecf\u7ed3\u675f")};
        return items;
    }

    public SelectItem[] getFlatNos() {
        if (this.flatNos != null) {
            return this.flatNos;
        }
        List list = LibClassM.getLibClassDList((String)"FlatNo");
        SelectItem[] domains = new SelectItem[list.size()];
        int i = 0;
        while (i < domains.length) {
            domains[i] = new SelectItem((Object)((LibClassD)list.get(i)).getItemno(), ((LibClassD)list.get(i)).getItemname());
            ++i;
        }
        this.flatNos = domains;
        return domains;
    }

    public Hashtable<String, String> getFlatNosMap() {
        if (this.flatNosMap == null) {
            List list = LibClassM.getLibClassDList((String)"FlatNo");
            this.flatNosMap = new Hashtable();
            for (LibClassD data : list) {
                this.flatNosMap.put(data.getItemno(), data.getItemname());
            }
        }
        return this.flatNosMap;
    }

    public SelectItem[] getPlacardstype() {
        if (this.placardstype != null) {
            return this.placardstype;
        }
        List list = LibClassM.getLibClassDList((String)"PlacardType");
        SelectItem[] domains = new SelectItem[list.size()];
        int i = 0;
        while (i < domains.length) {
            domains[i] = new SelectItem((Object)((LibClassD)list.get(i)).getItemno(), ((LibClassD)list.get(i)).getItemname());
            ++i;
        }
        this.placardstype = domains;
        return domains;
    }

    public Hashtable<String, String> getPlacardstypeMap() {
        if (this.placardstypeMap == null) {
            List list = LibClassM.getLibClassDList((String)"PlacardType");
            this.placardstypeMap = new Hashtable();
            for (LibClassD data : list) {
                this.placardstypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return this.placardstypeMap;
    }

    public String getQueryPlacardslist() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("editTime desc");
        this.mergePagedDataModel(facade.queryPlacards((Placards)this.findBean(Placards.class, 2), fliper, 0), new PagedFliper[]{fliper});
        return "";
    }

    public String delete() {
        this.authenticateDel();
        long seqid = this.findParamSeqid();
        if (seqid > 0L) {
            try {
                facade.deletePlacardsById(seqid);
            }
            catch (XLCardRuntimeException e) {
                this.mergeBean(e.getMessage(), "jsmessage");
            }
        }
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        long[] lArray = this.findParamSeqids();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long seqid = lArray[n2];
            try {
                facade.deletePlacardsById(seqid);
            }
            catch (XLCardRuntimeException e) {
                this.mergeBean(e.getMessage(), "jsmessage");
            }
            ++n2;
        }
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Placards data = (Placards)this.findBean(Placards.class);
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        data.setLabels("");
        if (data.getContentflag() == 0) {
            data.setCardlinkurl("");
        } else {
            data.setCardcontent("");
        }
        if (data.getUfile() != null) {
            this.upLoadFile(data);
        }
        try {
            facade.updatePlacards(data);
        }
        catch (XLCardRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.mergeBean(new Placards());
        return "";
    }

    public String add() {
        this.authenticateAdd();
        Placards data = (Placards)this.findBean(Placards.class, "placards");
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        data.setLabels("");
        if (data.getContentflag() == 0) {
            data.setCardlinkurl("");
        } else {
            data.setCardcontent("");
        }
        logger.info((Object)("data.getContentflag()=" + data.getContentflag() + "getCardcontent=" + data.getCardcontent() + "data.getUfile()=" + data.getUfile()));
        if (data.getUfile() != null) {
            this.upLoadFile(data);
        }
        data.setCardid(Utility.getUUID());
        try {
            facade.insertPlacards(data);
        }
        catch (XLCardRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.mergeBean(new Placards());
        return "";
    }

    public void upLoadFile(Placards data) {
        logger.info((Object)"upLoadFile begin!");
        UploadedFile theFile = data.getUfile();
        try {
            int lastIndexDol = theFile.getName().lastIndexOf(".");
            String fname = theFile.getName();
            String fsup = theFile.getName().substring(0, lastIndexDol);
            String fsub = fname.substring(fname.lastIndexOf(".") + 1, fname.length());
            fname = String.valueOf(fsup) + System.currentTimeMillis() + "." + fsub;
            InputStream in = theFile.getInputStream();
            FileOutputStream out = new FileOutputStream(String.valueOf(ApplicationConfigUtil.getPlaPicPath()) + fname);
            long fSize = theFile.getSize();
            byte[] buffer = new byte[(int)fSize];
            in.read(buffer, 0, (int)fSize);
            ((OutputStream)out).write(buffer, 0, (int)fSize);
            data.setPicurl(fname);
            ((OutputStream)out).close();
            in.close();
            if (data.getFlatno().equals("00")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getPlaPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicEsalesPath()) + fname));
            } else if (data.getFlatno().equals("01")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getPlaPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicPayPath()) + fname));
            } else if (data.getFlatno().equals("02")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getPlaPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicPay2Path()) + fname));
            }
            if (data.getFlatno().equals("PayCenter2.0")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getPlaPicPath()) + fname), (String)(String.valueOf(PayCenter2AppConfigUtil.getPlacardContentHtmlPath()) + File.separator + fname));
            }
        }
        catch (Exception ioe) {
            data.setPicurl("");
            ioe.printStackTrace();
        }
    }

    public String createpay2placardsvm() {
        this.authenticateRun();
        try {
            facade.generateIndexPlacardsPages();
            facade.generateHelpListPages();
            facade.generatePlacardsContentPages();
            facade.generateBankPages();
            IFacade.INSTANCE.generateProductsPages();
            IFacade.INSTANCE.generateBuyOneProductsPages();
            IFacade.INSTANCE.generateOrderPages();
            IFacade.INSTANCE.generateBuyAllProductsPages();
            Utility.callshell(ApplicationConfigUtil.getSyncpaywebshellPath());
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u5931\u8d25");
        }
        return "";
    }

    public String createplacardsvm() {
        this.authenticateRun();
        try {
            facade.generateIndexPages();
            facade.generatePlacardsPages();
            facade.generateActivitiesPages();
            Utility.callshell(ApplicationConfigUtil.getSyncpaywebshellPath());
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u5931\u8d25");
        }
        return "";
    }

    public String createPayCenter2Jsons() {
        this.authenticateRun();
        try {
            facade.genBulletinJson();
            logger.debug((Object)"facade.genBulletinJson();");
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genJifenJson();
            logger.debug((Object)"facade.genJifenJson();");
            IFacade.INSTANCE.genServingJson();
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genVipJson();
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genTasteVipJson();
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genOutlineJson();
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genPrizerJson();
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.genCDKeyJson();
            facade.genActivitiesJson();
            facade.genIndexAdvJson();
            facade.genThunderAdvJson();
            Utility.callshell(PayCenter2AppConfigUtil.getSynShellPath());
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u5931\u8d25");
        }
        return "";
    }

    public String createuupage() {
        this.authenticateRun();
        try {
            IFacade.INSTANCE.generateShoppingListPage();
            Utility.callshell(ApplicationConfigUtil.getSyncpaywebshellPath());
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u5931\u8d25");
        }
        return "";
    }

    public String createBonusPages() {
        this.authenticateRun();
        try {
            com.xunlei.bonusbiz.facade.IFacade.INSTANCE.generateWaresPage();
            Utility.callshell(ApplicationConfigUtil.getSyncpaywebshellPath());
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u6210\u529f");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.alertJS("\u9759\u6001\u9875\u9762\u751f\u6210\u5931\u8d25");
        }
        return "";
    }

    public String getEditedRecord() {
        Placards data = (Placards)this.findBean(Placards.class);
        System.out.println("######" + this.findParameter("sseqid") + "*******" + data.getSeqid());
        long seqid = this.findParamLong("sseqid");
        if (seqid != 0L) {
            this.mergeBean(facade.getPlacardsById(seqid));
            this.mergeBean(this.getFliper(), "fliper");
        }
        return "";
    }

    public UploadedFile getUfile() {
        return this.ufile;
    }

    public void setUfile(UploadedFile ufile) {
        this.ufile = ufile;
    }
}

