/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.web.model;

import com.xunlei.card.facade.IFacade;
import com.xunlei.card.util.Utility;
import com.xunlei.card.vo.Copartners;
import com.xunlei.card.vo.Copbizchannel;
import com.xunlei.card.vo.Coppayapply;
import com.xunlei.card.vo.Inform;
import com.xunlei.card.web.model.BaseManagedBean;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.Users;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

@FunRef(value="Coppayapply")
public class CoppayapplyManagedBean
extends BaseManagedBean {
    private boolean extSameRecord = false;
    private static Logger logger = Logger.getLogger(CoppayapplyManagedBean.class);
    private SelectItem[] copartners;

    private Coppayapply findQueryBean() {
        Coppayapply bean = (Coppayapply)this.findBean(Coppayapply.class, 2);
        if (this.isEmpty(bean.getApplystatus()) && this.isEmpty(bean.getFromdate()) && this.isEmpty(bean.getTodate())) {
            String checkrole = this.getUserCheckrole();
            if (checkrole.equals("CHE-01")) {
                String[] someapplyStatus = new String[]{"0", "1"};
                bean.setSomeapplystatus(someapplyStatus);
                bean.setApplystatus("0");
            } else if (checkrole.equals("CHE-04")) {
                String[] someapplyStatus = new String[]{"0"};
                bean.setSomeapplystatus(someapplyStatus);
                bean.setApplystatus("0");
            }
        }
        if (this.isEmpty(bean.getFromdate())) {
            bean.setFromdate(Utility.addDate(Utility.dateofnow(), "D", -30));
        }
        if (this.isEmpty(bean.getTodate())) {
            bean.setTodate(DatetimeUtil.today());
        }
        return bean;
    }

    public String getQueryCoppayapplylist() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("ApplyNoteCd desc");
        fliper.setPageSize(20);
        Coppayapply bean = this.findQueryBean();
        double sumpayamt = facade.getSumPayamtForqueryCoppayapply(bean);
        Sheet<Coppayapply> sheet = facade.queryCoppayapply(bean, fliper);
        logger.debug((Object)("sumpayamt=" + sumpayamt));
        logger.debug((Object)("rowcount=" + sheet.getRowcount()));
        double pagepayamt = 0.0;
        DecimalFormat df = new DecimalFormat("###0.00");
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            int pagecount = (sheet.getRowcount() + fliper.getPageSize() - 1) / fliper.getPageSize();
            for (Coppayapply coppayapply : list) {
                pagepayamt += coppayapply.getPayamt();
            }
            Coppayapply pagestat = new Coppayapply();
            pagestat.setApplynotecd("\u672c\u9875\u5c0f\u8ba1");
            pagestat.setPayamt(Double.valueOf(df.format(pagepayamt)));
            list.add(pagestat);
            Coppayapply sumstat = new Coppayapply();
            sumstat.setApplynotecd("\u603b\u8ba1");
            sumstat.setPayamt(Double.valueOf(df.format(sumpayamt)));
            list.add(sumstat);
            Sheet displaysheet = new Sheet(sheet.getRowcount() + pagecount * 2, (Collection)list);
            fliper.setPageSize(fliper.getPageSize() + 2);
            this.mergePagedDataModel(displaysheet, new PagedFliper[]{fliper});
        } else {
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String delete() {
        this.authenticateDel();
        long seqid = this.findParamLong("one_seqid");
        try {
            facade.deleteCoppayapplyById(seqid);
        }
        catch (XLRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "go_back";
    }

    public String getEditedRecord() {
        logger.debug((Object)("######" + this.findParameter("sseqid")));
        long seqid = this.findParamLong("sseqid");
        if (seqid != 0L) {
            Coppayapply c = facade.getCoppayapplyById(seqid);
            logger.debug((Object)("status=" + c.getApplystatus()));
            this.mergeBean(c);
            this.mergeBean(this.getFliper(), "fliper");
            String[] channelamts = c.getChannelamt().split(";");
            int i = 0;
            while (i < channelamts.length) {
                String onechannelamts = channelamts[i];
                Copbizchannel oldcb = new Copbizchannel();
                oldcb.setBizchanneltype(onechannelamts.substring(0, 2));
                oldcb.setCashamt(Double.parseDouble(onechannelamts.substring(3).trim()));
                if (i == 0) {
                    this.mergeBean(oldcb);
                } else {
                    this.mergeBean(oldcb, i + 1);
                }
                ++i;
            }
        }
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        long[] lArray = this.findParamSeqids();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long seqid = lArray[n2];
            facade.deleteCoppayapplyById(seqid);
            ++n2;
        }
        return "";
    }

    public void answerToEmail(Coppayapply data) {
        HashMap<String, String> mailParams = new HashMap<String, String>();
        mailParams.put("fromaddress", "xlpay@xunlei.com");
        String toaddress = null;
        String copartnername = facade.getNomalCopartnerIdAndName().get(data.getCopartnerid());
        if (data.getApplystatus().equals("0")) {
            toaddress = this.finderToAddress("CHE-04");
            logger.debug((Object)("\u8d22\u52a1\u4eba\u5458toaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", copartnername + "\u4ed8\u6b3e\u7533\u8bf7\u5f85\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + Users.findUser((String)data.getApplyby()).getTruename() + "&nbsp;" + data.getApplytime() + "\u65b0\u589e" + copartnername + "&nbsp;\u4ed8\u6b3e\u7533\u8bf7\u5f85\u5ba1\u6838\u3002<br>" + "\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        } else if (data.getApplystatus().equals("1")) {
            toaddress = this.finderToAddress("CHE-01");
            logger.debug((Object)("\u5546\u670dtoaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", copartnername + "\u4ed8\u6b3e\u7533\u8bf7\u672a\u901a\u8fc7\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + copartnername + "&nbsp;" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u672a\u901a\u8fc7\u8d22\u52a1\u4eba\u5458\u5ba1\u6838\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        } else if (data.getApplystatus().equals("2")) {
            toaddress = this.finderToAddress("CHE-01");
            logger.debug((Object)("\u5546\u670dtoaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", copartnername + "\u4ed8\u6b3e\u7533\u8bf7\u901a\u8fc7\u5ba1\u6838");
            String rspStr = "";
            String content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + copartnername + "&nbsp;" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u901a\u8fc7\u8d22\u52a1\u4eba\u5458\u5ba1\u6838\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            List<Users> userlist = IFacade.INSTANCE.queryCopUsers(data.getCopartnerid());
            if (userlist != null && userlist.size() > 0) {
                for (Users user : userlist) {
                    Inform inform = new Inform();
                    inform.setContent(content);
                    inform.setInformstatus("N");
                    inform.setInformtime(Utility.dateofnow());
                    inform.setInformto(user.getUserlogno());
                    inform.setTitle(String.valueOf(copartnername) + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "\u6210\u529f");
                    IFacade.INSTANCE.insertInform(inform);
                }
            }
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
            toaddress = String.valueOf(this.finderToAddress("CHE-03")) + ";" + this.finderToAddress("CHE-02");
            logger.debug((Object)("\u7ba1\u7406\u5c42\u3001\u4e3b\u7ba1toaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", copartnername + "\u4ed8\u6b3e");
            rspStr = "";
            content = "\u60a8\u597d\uff0c<br>&nbsp;&nbsp;" + copartnername + "\u4e8e" + data.getApplytime() + "\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u3002<br>" + "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + data.getApplynotecd() + "\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content);
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
            Copartners c = new Copartners();
            c.setCopartnerid(data.getCopartnerid());
            Copartners cdata = facade.findCopartners(c);
            toaddress = this.finderToAgentAddress(cdata);
            logger.debug((Object)("\u4ee3\u7406\u5546toaddress=" + toaddress));
            mailParams.put("toaddress", toaddress);
            mailParams.put("subject", "\u8fc5\u96f7\u6e20\u9053\u4ed8\u6b3e\u5df2\u7ecf\u6536\u5230");
            String rspStr2 = "";
            String content2 = cdata.getLinkman() + ":<br>" + "\u60a8\u597d\uff01<br>&nbsp;&nbsp;\u8d35\u53f8\uff08" + copartnername + "\uff09\u4e8e" + data.getApplytime() + "\u5411\u8fc5\u96f7\u6e20\u9053\u4ed8\u6b3e" + data.getPayamt() + "&nbsp;\u5143\u5df2\u7ecf\u6536\u5230\u3002<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fc5\u96f7\u96f7\u70b9\u7cfb\u7edf <br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + DatetimeUtil.today();
            mailParams.put("body", content2);
            List<Users> userlist2 = IFacade.INSTANCE.queryCopUsers(data.getCopartnerid());
            if (userlist2 != null && userlist2.size() > 0) {
                for (Users user : userlist2) {
                    Inform inform = new Inform();
                    inform.setContent(content2);
                    inform.setInformstatus("N");
                    inform.setInformtime(Utility.dateofnow());
                    inform.setInformto(user.getUserlogno());
                    inform.setTitle(String.valueOf(data.getApplytime()) + " \u8fc5\u96f7\u6e20\u9053\u4ed8\u6b3e\u5df2\u7ecf\u6536\u5230");
                    IFacade.INSTANCE.insertInform(inform);
                }
            }
            Roles roles = new Roles();
            roles.setRoletype("SYS");
            roles.setRoleno("CHE-01");
            List serverlist = IFacadeCommon.INSTANCE.getAllUsersInRoles(roles);
            if (serverlist != null && serverlist.size() > 0) {
                for (Users user : serverlist) {
                    Inform inform = new Inform();
                    inform.setContent(content2);
                    inform.setInformstatus("N");
                    inform.setInformtime(Utility.dateofnow());
                    inform.setInformto(user.getUserlogno());
                    inform.setTitle(String.valueOf(data.getApplytime()) + " " + copartnername + "\u8fc5\u96f7\u6e20\u9053\u4ed8\u6b3e\u5df2\u7ecf\u6536\u5230");
                    IFacade.INSTANCE.insertInform(inform);
                }
            }
            if (Utility.sendHtmlMail(mailParams)) {
                logger.debug((Object)"Email has been sent successfully.");
            }
        }
    }

    public String add() {
        logger.debug((Object)"add----");
        this.authenticateAdd();
        Coppayapply data = (Coppayapply)this.findBean(Coppayapply.class);
        try {
            data.setApplynotecd(facade.createApplyNoteCd("D"));
            data.setChannelno("0000");
            data.setApplyby(this.currentUserLogo());
            data.setApplytime(this.now());
            data.setApplyip(this.currentUserLogIP());
            data.setApplyremark(data.getApplyremark());
            data.setApplystatus("0");
            data.setCheck1result("0");
            data.setVerid(1L);
            data.setBalancedate(DatetimeUtil.today());
            logger.debug((Object)("ApplyNoteCd=" + data.getApplynotecd() + "\u6e20\u9053\u5206\u914d\u91d1\u989d\uff1a" + data.getChannelamt()));
            facade.insertCoppayapply(data);
            this.answerToEmail(data);
        }
        catch (Exception e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Coppayapply data = (Coppayapply)this.findBean(Coppayapply.class);
        data.setApplystatus("0");
        data.setCheck1result("0");
        data.setApplyby(this.currentUserLogo());
        data.setApplytime(this.now());
        data.setApplyip(this.currentUserLogIP());
        logger.debug((Object)("edit\u6e20\u9053\u5206\u914d\u91d1\u989d\uff1a" + data.getChannelamt() + "verid=" + data.getVerid()));
        try {
            facade.updateCoppayapply(data);
            if (!facade.findCoppayapply(data).getApplystatus().equals("0") && !facade.findCoppayapply(data).getApplystatus().equals("")) {
                this.answerToEmail(data);
            }
        }
        catch (Exception e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public String getBeforeCopbizchannel() {
        logger.debug((Object)"getBeforeCopbizchannel()");
        this.mergeBean(new Copbizchannel());
        this.mergeBean(new Copbizchannel(), 2);
        this.mergeBean(new Copbizchannel(), 3);
        this.mergeBean(new Copbizchannel(), 4);
        this.mergeBean(new Copbizchannel(), 5);
        this.mergeBean(new Copbizchannel(), 6);
        Coppayapply bean = (Coppayapply)this.findBean(Coppayapply.class);
        if (bean != null) {
            Copbizchannel cb = new Copbizchannel();
            cb.setCopartnerid(bean.getCopartnerid());
            cb.setBizchannelstatus("N");
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid asc");
            Sheet<Copbizchannel> copbizchannellist = facade.queryCopbizchannel(cb, fliper);
            List list = (List)copbizchannellist.getDatas();
            logger.debug((Object)("\u67e5\u5230\u6e20\u9053list.size()=" + list.size()));
            if (list.size() == 0) {
                this.alertJS("\u8be5\u4ee3\u7406\u5546\u6ca1\u6709\u6e20\u9053\uff0c\u4e0d\u80fd\u4ed8\u6b3e\uff01");
                this.setExtSameRecord(true);
            } else {
                int i = 0;
                while (i < list.size()) {
                    Copbizchannel oldcb = (Copbizchannel)list.get(i);
                    oldcb.setCashamt(0.0);
                    if (i == 0) {
                        this.mergeBean(oldcb);
                    } else {
                        this.mergeBean(oldcb, i + 1);
                    }
                    ++i;
                }
                this.setExtSameRecord(false);
            }
        }
        this.mergeBean(bean);
        logger.debug((Object)"end getBeforeCopbizchannel!");
        return "";
    }

    public String auditYes() {
        this.authenticateEdit();
        Coppayapply newdata = (Coppayapply)this.findBean(Coppayapply.class);
        try {
            Coppayapply data = facade.getCoppayapplyById(newdata.getSeqid());
            logger.debug((Object)("auditYes--seqid()=" + newdata.getSeqid() + " remark=" + newdata.getCheck1remark() + " verid=" + newdata.getVerid()));
            data.setCheck1by(this.currentUserLogo());
            data.setCheck1time(this.now());
            data.setCheck1ip(this.currentUserLogIP());
            data.setCheck1remark(newdata.getCheck1remark());
            data.setCheck1result("1");
            data.setApplystatus("2");
            data.setBalancedate(DatetimeUtil.today());
            data.setTradesn(Utility.getTradeSn());
            data.setVerid(newdata.getVerid());
            facade.updateCoppayapply(data);
            this.answerToEmail(data);
            this.alertJS("\u5ba1\u6838\u64cd\u4f5c\u6210\u529f.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            this.alertJS(e.getMessage());
        }
        return "";
    }

    public String auditNo() {
        this.authenticateEdit();
        Coppayapply newdata = (Coppayapply)this.findBean(Coppayapply.class);
        try {
            Coppayapply data = facade.getCoppayapplyById(newdata.getSeqid());
            logger.debug((Object)("auditNo--seqid()=" + newdata.getSeqid() + " remark=" + newdata.getCheck1remark() + " verid=" + newdata.getVerid()));
            data.setCheck1by(this.currentUserLogo());
            data.setCheck1time(this.now());
            data.setCheck1ip(this.currentUserLogIP());
            data.setCheck1remark(newdata.getCheck1remark());
            data.setCheck1result("2");
            data.setApplystatus("1");
            data.setVerid(newdata.getVerid());
            facade.updateCoppayapply(data);
            this.answerToEmail(data);
            this.alertJS("\u5ba1\u6838\u64cd\u4f5c\u6210\u529f.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            this.alertJS(e.getMessage());
        }
        return "";
    }

    public SelectItem[] getNomalCopartnerlist() {
        if (this.copartners != null) {
            return this.copartners;
        }
        List<Copartners> list = facade.getNomalCopartnerFlagAndName("N");
        SelectItem[] items = new SelectItem[list.size() + 1];
        items[0] = new SelectItem((Object)"", "");
        int i = 0;
        while (i < list.size()) {
            items[i + 1] = new SelectItem((Object)list.get(i).getCopartnerid(), String.valueOf(list.get(i).getChooseflag()) + "-" + list.get(i).getCopartnername());
            ++i;
        }
        this.copartners = items;
        return items;
    }

    public List<SelectItem> getBizChannelTypes() {
        ArrayList<SelectItem> items = (ArrayList<SelectItem>)this.getRequestAttribute("bizChannelType");
        if (items == null) {
            Map map = LibClassM.getStringValues((String)"BizChannelType");
            items = new ArrayList<SelectItem>(map.size());
            for (Map.Entry en : map.entrySet()) {
                items.add(new SelectItem(en.getKey(), (String)en.getValue()));
            }
            this.setRequestAttribute("bizChannelType", items);
        }
        return items;
    }

    public Hashtable<String, String> getBizChannelTypesMap() {
        Hashtable ht = (Hashtable)this.getRequestAttribute("bizChannelTypeMap");
        if (ht == null) {
            ht = new Hashtable();
            Map map = LibClassM.getStringValues((String)"BizChannelType");
            ht.putAll(map);
            this.setRequestAttribute("bizChannelTypeMap", ht);
        }
        return ht;
    }

    public List<SelectItem> getAllapplyStatuses() {
        ArrayList<SelectItem> items = (ArrayList<SelectItem>)this.getRequestAttribute("CopPaymentApplySts");
        if (items == null) {
            Map map = LibClassM.getStringValues((String)"CopPaymentApplySts");
            items = new ArrayList<SelectItem>(map.size());
            for (Map.Entry en : map.entrySet()) {
                items.add(new SelectItem(en.getKey(), (String)en.getValue()));
            }
            this.setRequestAttribute("CopPaymentApplySts", items);
        }
        return items;
    }

    public Hashtable<String, String> getAllapplyStatusesMap() {
        Hashtable ht = (Hashtable)this.getRequestAttribute("CopPaymentApplyStsMap");
        if (ht == null) {
            ht = new Hashtable();
            Map map = LibClassM.getStringValues((String)"CopPaymentApplySts");
            ht.putAll(map);
            this.setRequestAttribute("CopPaymentApplyStsMap", ht);
        }
        return ht;
    }

    public boolean isExtSameRecord() {
        return this.extSameRecord;
    }

    public void setExtSameRecord(boolean extSameRecord) {
        this.extSameRecord = extSameRecord;
    }
}

