/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.web.model;

import com.xunlei.card.facade.IFacade;
import com.xunlei.card.vo.Copartners;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class BaseManagedBean
extends AbstractManagedBean {
    private static Logger logger = Logger.getLogger(BaseManagedBean.class);
    protected static final IFacade facade = IFacade.INSTANCE;
    protected String currole;
    private boolean superman = false;

    protected int[] toIntArray(String idstr) {
        String[] array = idstr.split(",");
        int[] ids = new int[array.length];
        int i = 0;
        while (i < ids.length) {
            if (array[i].length() > 0) {
                ids[i] = Integer.parseInt(array[i].trim(), 10);
            }
            ++i;
        }
        return ids;
    }

    protected String toString(int ... ids) {
        StringBuilder sb = new StringBuilder(ids.length * 3);
        boolean first = true;
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (!first) {
                sb.append(",");
            }
            sb.append(id);
            if (first) {
                first = false;
            }
            ++n2;
        }
        return sb.toString();
    }

    protected List<SelectItem> transfer(Map<?, ?> map) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
        for (Map.Entry<?, ?> s : map.entrySet()) {
            items.add(new SelectItem(s.getKey(), "" + s.getValue()));
        }
        return items;
    }

    protected List<SelectItem> transfer(List<String> list) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(list.size());
        for (String s : list) {
            items.add(new SelectItem((Object)s, s));
        }
        return items;
    }

    public String currentUserLogIP() {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getRemoteAddr();
    }

    protected String finderToAddress(String roleno) {
        String toaddress = "";
        Roles role = new Roles();
        role.setRoleno(roleno);
        role.setRoletype("SYS");
        List<Users> users = facade.getAllUsersInRoles(role);
        logger.debug((Object)("roleno=" + roleno + " size=" + users.size()));
        for (Users u : users) {
            logger.debug((Object)("logno=" + u.getUserlogno() + " getEmail=" + u.getEmail()));
            if (!this.isNotEmpty(u.getEmail())) continue;
            toaddress = String.valueOf(toaddress) + u.getEmail().trim() + ";";
        }
        logger.debug((Object)("toaddress=" + toaddress));
        return toaddress.length() > 0 ? toaddress.substring(0, toaddress.length() - 1) : toaddress;
    }

    protected String finderToAgentAddress(Copartners data) {
        String toaddress = "";
        String copartnerid = "";
        copartnerid = data.getCopartnerno() != null && data.getCopartnerno().trim().length() > 0 ? data.getCopartnerno() : data.getCopartnerid();
        List<Users> users = facade.queryCopUsers(copartnerid);
        for (Users u : users) {
            if (!data.getUserlogno().equalsIgnoreCase(u.getUserlogno())) continue;
            toaddress = u.getEmail();
            break;
        }
        return toaddress;
    }

    protected String getUserCheckrole() {
        String checkrole = "";
        UserInfo userinfo = this.currentUserInfo();
        int num = userinfo.getSysRolenos().length;
        int i = 0;
        while (i < num) {
            checkrole = userinfo.getSysRolenos()[i];
            if (checkrole.equals("CHE-01")) {
                checkrole = "CHE-01";
                break;
            }
            if (checkrole.equals("CHE-02")) {
                checkrole = "CHE-02";
                break;
            }
            if (checkrole.equals("CHE-03")) {
                checkrole = "CHE-03";
                break;
            }
            if (checkrole.equals("CHE-04")) {
                checkrole = "CHE-04";
                break;
            }
            if (checkrole.equals("CHE-05")) {
                checkrole = "CHE-05";
                break;
            }
            ++i;
        }
        this.getHttpServletRequest().getSession(true).setAttribute("checkrole", (Object)checkrole);
        return checkrole;
    }

    protected final String currentUserCopno() {
        String copno = (String)this.getHttpServletRequest().getSession(true).getAttribute("currentUserCopno");
        return copno == null ? null : copno;
    }

    public String getCurrole() {
        this.currole = this.getUserCheckrole();
        return this.currole;
    }

    public void setCurrole(String currole) {
        this.currole = currole;
    }

    public boolean isSuperman() {
        this.superman = this.currentUserInfo().isSuperman();
        return this.superman;
    }

    public void setSuperman(boolean superman) {
        this.superman = superman;
    }

    public SelectItem[] getLibClassD(SelectItem[] items, String classno) {
        if (items == null) {
            List list = LibClassM.getLibClassDList((String)classno);
            items = new SelectItem[list.size()];
            int i = 0;
            while (i < items.length) {
                items[i] = new SelectItem((Object)((LibClassD)list.get(i)).getItemno(), ((LibClassD)list.get(i)).getItemname());
                ++i;
            }
        }
        return items;
    }

    public Hashtable<String, String> getLibClassDMap(Hashtable map, String classno) {
        if (map == null) {
            List list = LibClassM.getLibClassDList((String)classno);
            map = new Hashtable<String, String>();
            for (LibClassD data : list) {
                map.put(data.getItemno(), data.getItemname());
            }
        }
        return map;
    }
}

