/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.web.model;

import com.xunlei.card.util.ApplicationConfigUtil;
import com.xunlei.card.util.XLCardRuntimeException;
import com.xunlei.card.vo.Advs;
import com.xunlei.card.vo.Domains;
import com.xunlei.card.web.model.BaseManagedBean;
import com.xunlei.common.util.FileUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

@FunRef(value="Advs")
public class AdvsManagedBean
extends BaseManagedBean {
    private static Logger logger = Logger.getLogger(AdvsManagedBean.class);
    private SelectItem[] advTypeItems;
    private SelectItem[] domainItems;

    public SelectItem[] getDomains() throws Exception {
        if (this.domainItems == null) {
            Domains d = new Domains();
            List domains = (List)facade.queryDomains(d, null).getDatas();
            if (domains == null || domains.size() == 0) {
                SelectItem[] items = new SelectItem[]{new SelectItem((Object)"", "")};
                this.domainItems = items;
            } else {
                int size = domains.size() + 1;
                SelectItem[] items = new SelectItem[size];
                items[0] = new SelectItem((Object)"", "");
                int i = 1;
                while (i < size) {
                    Domains domain = (Domains)domains.get(i - 1);
                    items[i] = new SelectItem((Object)domain.getDomainno(), domain.getDomainname());
                    ++i;
                }
                this.domainItems = items;
            }
        }
        return this.domainItems;
    }

    public SelectItem[] getAdvTypes() {
        if (this.advTypeItems != null) {
            return this.advTypeItems;
        }
        SelectItem[] items = new SelectItem[]{new SelectItem((Object)"", ""), new SelectItem((Object)"0", "\u6587\u5b57\u5e7f\u544a"), new SelectItem((Object)"1", "\u56fe\u7247\u5e7f\u544a"), new SelectItem((Object)"2", "\u53cb\u60c5\u94fe\u63a5")};
        this.advTypeItems = items;
        return this.advTypeItems;
    }

    public Hashtable<String, String> getAdvTypesMap() {
        Hashtable ht = (Hashtable)this.getRequestAttribute("advTypesMap");
        if (ht == null) {
            ht = new Hashtable();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(4);
            map.put("", "");
            map.put("0", "\u6587\u5b57\u5e7f\u544a");
            map.put("1", "\u56fe\u7247\u5e7f\u544a");
            map.put("2", "\u53cb\u60c5\u94fe\u63a5");
            ht.putAll(map);
            this.setRequestAttribute("advTypesMap", ht);
        }
        return ht;
    }

    public String getQueryAdvslist() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("editTime desc");
        this.mergePagedDataModel(facade.queryAdvs((Advs)this.findBean(Advs.class, 2), fliper), new PagedFliper[]{fliper});
        return "";
    }

    public String delete() {
        this.authenticateDel();
        long seqid = this.findParamSeqid();
        if (seqid > 0L) {
            try {
                facade.deleteAdvsById(seqid);
            }
            catch (XLCardRuntimeException e) {
                this.mergeBean(e.getMessage(), "jsmessage");
            }
        }
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        long[] lArray = this.findParamSeqids();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long seqid = lArray[n2];
            try {
                facade.deleteAdvsById(seqid);
            }
            catch (XLCardRuntimeException e) {
                this.mergeBean(e.getMessage(), "jsmessage");
            }
            ++n2;
        }
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Advs data = (Advs)this.findBean(Advs.class);
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        if (data.getUfile() != null) {
            this.upLoadFile(data);
        }
        try {
            facade.updateAdvs(data);
        }
        catch (XLCardRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.mergeBean(new Advs());
        return "";
    }

    public String add() {
        this.authenticateAdd();
        Advs data = (Advs)this.findBean(Advs.class);
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        data.setInputby(this.currentUserLogo());
        data.setInputtime(this.now());
        if (data.getUfile() != null) {
            this.upLoadFile(data);
        }
        try {
            facade.insertAdvs(data);
        }
        catch (XLCardRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        return "";
    }

    public void upLoadFile(Advs data) {
        UploadedFile theFile = data.getUfile();
        try {
            int lastIndexDol = theFile.getName().lastIndexOf(".");
            String fname = theFile.getName();
            String fsup = theFile.getName().substring(0, lastIndexDol);
            String fsub = fname.substring(fname.lastIndexOf(".") + 1, fname.length());
            fname = String.valueOf(fsup) + System.currentTimeMillis() + "." + fsub;
            InputStream in = theFile.getInputStream();
            FileOutputStream out = new FileOutputStream(String.valueOf(ApplicationConfigUtil.getAdvPicPath()) + fname);
            long fSize = theFile.getSize();
            byte[] buffer = new byte[(int)fSize];
            in.read(buffer, 0, (int)fSize);
            ((OutputStream)out).write(buffer, 0, (int)fSize);
            data.setPicurl(fname);
            ((OutputStream)out).close();
            in.close();
            List list = facade.getDomainsByDomainno(data.getDomainno());
            Domains domain = (Domains)list.get(0);
            if (domain.getFlatno().equals("00")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getAdvPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicEsalesPath()) + "eguanggao" + File.separator + fname));
            } else if (domain.getFlatno().equals("01")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getAdvPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicPayPath()) + "pguanggao" + File.separator + fname));
            } else if (domain.getFlatno().equals("02")) {
                FileUtil.copyFile((String)(String.valueOf(ApplicationConfigUtil.getAdvPicPath()) + fname), (String)(String.valueOf(ApplicationConfigUtil.getPlaPicPay2Path()) + "pguanggao" + File.separator + fname));
            }
        }
        catch (Exception ioe) {
            data.setPicurl("");
            ioe.printStackTrace();
        }
    }

    public String getEditedRecord() {
        Advs data = (Advs)this.findBean(Advs.class);
        long seqid = this.findParamLong("sseqid");
        if (seqid != 0L) {
            this.mergeBean(facade.getAdvsById(seqid));
            this.mergeBean(this.getFliper(), "fliper");
        }
        return "";
    }
}

