/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.card.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VmUtil {
    private static Logger logger = Logger.getLogger(VmUtil.class);

    public static String getVmConent(Context ctx, String vmPath, String vmFile) throws Exception {
        VelocityEngine ve = VmUtil.getVelocityEngineUTF8(vmPath);
        Template template = ve.getTemplate(vmFile);
        StringWriter writer = new StringWriter();
        template.merge(ctx, (Writer)writer);
        String content = writer.toString();
        return content;
    }

    public static VelocityEngine getVelocityEngineUTF8(String loaderPath) {
        VelocityEngine ve = null;
        if (ve == null) {
            ve = new VelocityEngine();
            ve.setProperty("file.resource.loader.path", (Object)loaderPath);
            ve.setProperty("input.encoding", (Object)"utf-8");
            ve.setProperty("output.encoding", (Object)"utf-8");
            ve.setProperty("default.contentType", (Object)"text/html;charset=UTF-8");
            try {
                ve.init();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return ve;
    }

    public static void createFile(String path, String content) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        bw.write(content);
        bw.close();
    }
}

